/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.mixin.integration.connector;

import io.github.apace100.calio.Calio;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

public abstract class CustomNonItalicNameMixin {

    @Mixin(value={AnvilMenu.class})
    public static abstract class RemoveNonItalicOnRename {
        @Inject(method={"updateResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;setCustomName(Lnet/minecraft/text/Text;)Lnet/minecraft/item/ItemStack;")}, locals=LocalCapture.CAPTURE_FAILHARD)
        private void removeNonItalicFlag(CallbackInfo ci, ItemStack itemStack, int i, int j, int k, ItemStack itemStack2) {
            CompoundTag display = itemStack2.m_41737_("display");
            if (display != null && display.m_128441_("NonItalicName")) {
                display.m_128473_("NonItalicName");
            }
        }
    }

    @Mixin(value={Gui.class})
    public static abstract class ModifyItalicDisplayHud {
        @Shadow
        @Final
        private Minecraft f_92986_;
        @Shadow
        private int f_92993_;
        @Shadow
        private ItemStack f_92994_;
        @Shadow
        private int f_92977_;
        @Shadow
        private int f_92978_;

        @Shadow
        public abstract Font m_93082_();

        @Inject(method={"renderHeldItemTooltip"}, at={@At(value="HEAD")}, cancellable=true)
        private void hasCustomNameWhichIsItalic(GuiGraphics context, CallbackInfo ci) {
            this.f_92986_.m_91307_().m_6180_("selectedItemName");
            if (this.f_92993_ > 0 && !this.f_92994_.m_41619_()) {
                int l;
                MutableComponent mutableText = Component.m_237119_().m_7220_(this.f_92994_.m_41786_()).m_130940_(this.f_92994_.m_41791_().f_43022_);
                if (this.f_92994_.m_41788_() && !Calio.hasNonItalicName(this.f_92994_)) {
                    mutableText.m_130940_(ChatFormatting.ITALIC);
                }
                int i = this.m_93082_().m_92852_((FormattedText)mutableText);
                int j = (this.f_92977_ - i) / 2;
                int k = this.f_92978_ - 59;
                if (!this.f_92986_.f_91072_.m_105205_()) {
                    k += 14;
                }
                if ((l = (int)((float)this.f_92993_ * 256.0f / 10.0f)) > 255) {
                    l = 255;
                }
                if (l > 0) {
                    Objects.requireNonNull(this.m_93082_());
                    context.m_280509_(j - 2, k - 2, j + i + 2, k + 9 + 2, this.f_92986_.f_91066_.m_92143_(0));
                    context.m_280430_(this.m_93082_(), (Component)mutableText, j, k, 0xFFFFFF + (l << 24));
                }
            }
            this.f_92986_.m_91307_().m_7238_();
            ci.cancel();
        }
    }

    @Mixin(value={ItemStack.class})
    public static abstract class ModifyItalicDisplayItem {
        @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasCustomName()Z"))
        private boolean hasCustomNameWhichIsItalic(ItemStack stack) {
            return stack.m_41788_() && !Calio.hasNonItalicName(stack);
        }
    }
}

