/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio;

import io.github.apace100.calio.mixin.WeightedListEntryAccessor;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.ai.behavior.ShufflingList;

public class FilterableWeightedList<U>
extends ShufflingList<U> {
    private Predicate<U> filter;

    public int size() {
        return this.f_147917_.size();
    }

    public void addFilter(Predicate<U> filter) {
        if (this.hasFilter()) {
            this.filter = this.filter.and(filter);
        } else {
            this.setFilter(filter);
        }
    }

    public void setFilter(Predicate<U> filter) {
        this.filter = filter;
    }

    public void removeFilter() {
        this.filter = null;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public Stream<U> m_147932_() {
        if (this.filter != null) {
            return this.f_147917_.stream().map(ShufflingList.WeightedEntry::m_147940_).filter(this.filter);
        }
        return super.m_147932_();
    }

    public Stream<ShufflingList.WeightedEntry<U>> entryStream() {
        return this.f_147917_.stream().filter(entry -> this.filter == null || this.filter.test(entry.m_147940_()));
    }

    public void addAll(FilterableWeightedList<U> other) {
        other.entryStream().forEach(entry -> this.m_147929_(entry.m_147940_(), ((WeightedListEntryAccessor)entry).getWeight()));
    }

    public U pickRandom(Random random) {
        return this.pickRandom();
    }

    public U pickRandom() {
        return (U)this.m_147922_().m_147932_().findFirst().orElseThrow(RuntimeException::new);
    }

    public FilterableWeightedList<U> copy() {
        FilterableWeightedList<U> copied = new FilterableWeightedList<U>();
        copied.addAll(this);
        return copied;
    }
}

