/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2540;

public class Float2 {
    public static final Float2 ZERO = new Float2(0.0, 0.0);
    public static final Float2 X_AXIS = new Float2(1.0, 0.0);
    public static final Float2 Y_AXIS = new Float2(0.0, 1.0);
    public static final Float2 mX_AXIS = new Float2(-1.0, 0.0);
    public static final Float2 mY_AXIS = new Float2(0.0, -1.0);
    public static final Float2 IDENTITY = new Float2(1.0, 1.0);
    public static final Codec<Float2> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(o -> Float.valueOf((float)o.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(o -> Float.valueOf((float)o.y))).apply((Applicative)instance, Float2::new));
    public final double x;
    public final double y;

    public Float2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Float2 of(double x, double y) {
        return new Float2(x, y);
    }

    public static Float2 of(double xy) {
        return new Float2(xy, xy);
    }

    public static Float2 blockAligned(double x, double y) {
        return new Float2(Float3.toBlockPos(x), Float3.toBlockPos(y));
    }

    public double dot(Float2 p) {
        return this.x * p.x + this.y * p.y;
    }

    public Float2 div(Float2 p) {
        return new Float2(this.x / p.x, this.y / p.y);
    }

    public Float2 mul(Float2 p) {
        return new Float2(this.x * p.x, this.y * p.y);
    }

    public Float2 square() {
        return new Float2(this.x * this.x, this.y * this.y);
    }

    public Float2 add(Float2 p) {
        return new Float2(this.x + p.x, this.y + p.y);
    }

    public Float2 add(double d) {
        return new Float2(this.x + d, this.y + d);
    }

    public Float2 sub(double d) {
        return new Float2(this.x - d, this.y - d);
    }

    public Float2 abs() {
        return new Float2(Math.abs(this.x), Math.abs(this.y));
    }

    public Float2 max(double d) {
        return new Float2(Math.max(this.x, d), Math.max(this.y, d));
    }

    public Float2 min(double d) {
        return new Float2(Math.min(this.x, d), Math.min(this.y, d));
    }

    public double maxComp() {
        return Math.max(this.x, this.y);
    }

    public double minComp() {
        return Math.min(this.x, this.y);
    }

    public Float2 sub(Float2 p) {
        return new Float2(this.x - p.x, this.y - p.y);
    }

    public Float2 mul(double d) {
        return new Float2(this.x * d, this.y * d);
    }

    public Float2 div(double d) {
        return new Float2(this.x / d, this.y / d);
    }

    public double angleTo(Float2 target) {
        return Math.acos(Math.max(-1.0, Math.min(1.0, this.dot(target) / (this.length() * target.length()))));
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquare() {
        return this.x * this.x + this.y * this.y;
    }

    public Float2 normalized() {
        double d = this.length();
        return new Float2(this.x / d, this.y / d);
    }

    public double distSquare(Float2 b) {
        return Math.pow(this.x - b.x, 2.0) + Math.pow(this.y - b.y, 2.0);
    }

    public double distSquare(class_2338 b) {
        return Math.pow(this.x - (double)b.method_10263(), 2.0) + Math.pow(this.y - (double)b.method_10264(), 2.0);
    }

    public Float2 rotate(double a) {
        return Float2.of(this.x * Math.cos(a) - this.y * Math.sin(a), this.x * Math.sin(a) + this.y * Math.cos(a));
    }

    public Float2 ceil() {
        return Float2.of(Math.ceil(this.x), Math.ceil(this.y));
    }

    public Float2 floor() {
        return Float2.of(Math.floor(this.x), Math.floor(this.y));
    }

    public Float2 round() {
        return Float2.of(Math.round(this.x), Math.round(this.y));
    }

    public Float2 conservative() {
        return Float2.of(Float3.conservative(this.x), Float3.conservative(this.y));
    }

    public Float2 blockAligned() {
        return new Float2(Float3.toBlockPos(this.x), Float3.toBlockPos(this.y));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Float2 pos = (Float2)o;
        return Math.abs(pos.x - this.x) < 1.0E-10 && Math.abs(pos.y - this.y) < 1.0E-10;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "(" + Float3.toString(this.x) + ", " + Float3.toString(this.y) + ")";
    }

    public void serializeToNetwork(class_2540 buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
    }

    public static Float2 deserializeFromNetwork(class_2540 buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        return Float2.of(x, y);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public Float2 xx() {
        return new Float2(this.x, this.x);
    }

    public Float2 xy() {
        return new Float2(this.x, this.y);
    }

    public Float2 yx() {
        return new Float2(this.y, this.x);
    }

    public Float2 yy() {
        return new Float2(this.y, this.y);
    }

    public Float3 xxx() {
        return Float3.of(this.x, this.x, this.x);
    }

    public Float3 xxy() {
        return Float3.of(this.x, this.x, this.y);
    }

    public Float3 xyx() {
        return Float3.of(this.x, this.y, this.x);
    }

    public Float3 xyy() {
        return Float3.of(this.x, this.y, this.y);
    }

    public Float3 yxx() {
        return Float3.of(this.y, this.x, this.x);
    }

    public Float3 yxy() {
        return Float3.of(this.y, this.x, this.y);
    }

    public Float3 yyx() {
        return Float3.of(this.y, this.y, this.x);
    }

    public Float3 yyy() {
        return Float3.of(this.y, this.y, this.y);
    }
}

