/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.render;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Markers {
    public static final ResourceLocation MARKER_ARROW = new ResourceLocation("merchantmarkers", "textures/entity/villager/arrow.png");
    public static final ResourceLocation ICON_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/overlay.png");
    public static final ResourceLocation NUMBER_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/numbers.png");
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("merchantmarkers", "textures/entity/villager/default.png");
    public static final ResourceLocation EMPTY_MARKER = new ResourceLocation("merchantmarkers", "textures/entity/villager/empty.png");
    private static Supplier<InputStream> emptyMarkerResource = null;
    private static Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();

    public static InputStream getEmptyInputStream() {
        if (emptyMarkerResource == null) {
            emptyMarkerResource = () -> {
                Minecraft mc = Minecraft.m_91087_();
                ResourceManager manager = mc.m_91098_();
                try {
                    return ((Resource)manager.m_213713_(EMPTY_MARKER).get()).m_215507_();
                }
                catch (Exception e) {
                    return InputStream.nullInputStream();
                }
            };
        }
        return (InputStream)emptyMarkerResource.get();
    }

    public static String getProfessionName(Entity entity) {
        String iconName = "";
        if (entity instanceof Villager) {
            VillagerProfession profession = ((Villager)entity).m_7141_() != null ? ((Villager)entity).m_7141_().m_35571_() : null;
            iconName = (profession != null ? profession.toString() : "none").replace(":", "__");
        } else if (entity instanceof WanderingTrader) {
            iconName = "wandering_trader";
        } else if (entity instanceof Merchant) {
            iconName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135815_();
        } else {
            iconName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135815_();
            Minecraft mc = Minecraft.m_91087_();
            ResourceManager manager = mc.m_91098_();
            if (!manager.m_213713_(new ResourceLocation("merchantmarkers", "textures/entity/villager/markers/" + iconName + ".png")).isPresent()) {
                iconName = "";
            }
        }
        return iconName;
    }

    public static int getProfessionLevel(Entity entity) {
        int level = 0;
        if (MerchantMarkersConfig.getInstance().showLevels() && entity instanceof Villager) {
            level = ((Villager)entity).m_7141_().m_35576_();
        }
        return level;
    }

    public static void renderMarker(EntityRenderer<?> renderer, Entity entity, Component component, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (Markers.shouldShowMarker(entity)) {
            double maxDistance;
            Minecraft mc = Minecraft.m_91087_();
            String profession = Markers.getProfessionName(entity);
            int level = Markers.getProfessionLevel(entity);
            double squareDistance = renderer.f_114476_.m_114471_(entity);
            if (squareDistance > (maxDistance = ((Double)MerchantMarkersConfig.getInstance().maxDistance.get()).doubleValue()) * maxDistance) {
                return;
            }
            double fadePercent = (Double)MerchantMarkersConfig.getInstance().fadePercent.get();
            float currentAlpha = 1.0f;
            if (fadePercent < 100.0) {
                double startFade = (1.0 - fadePercent / 100.0) * maxDistance;
                currentAlpha = (float)Mth.m_14008_((double)(1.0 - (Math.sqrt(squareDistance) - startFade) / (maxDistance - startFade)), (double)0.0, (double)1.0);
                currentAlpha = (float)((double)currentAlpha * (Double)MerchantMarkersConfig.getInstance().opacity.get());
            }
            float entityHeight = entity.m_20206_() + 0.5f;
            int y = "deadmau5".equals(component.getString()) ? -28 : -18;
            y -= ((Integer)MerchantMarkersConfig.getInstance().verticalOffset.get()).intValue();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)entityHeight, 0.0);
            poseStack.m_252781_(renderer.f_114476_.m_253208_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            boolean showArrow = (Boolean)MerchantMarkersConfig.getInstance().showArrow.get();
            if (((Boolean)MerchantMarkersConfig.getInstance().showThroughWalls.get()).booleanValue()) {
                RenderSystem.disableDepthTest();
                Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y, 0.3f * currentAlpha);
                if (showArrow) {
                    Markers.renderArrow(poseStack, 0, y, 0.3f * currentAlpha);
                }
            }
            RenderSystem.enableDepthTest();
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y, currentAlpha);
            if (showArrow) {
                Markers.renderArrow(poseStack, 0, y, currentAlpha);
            }
            if (depthTestEnabled) {
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.disableDepthTest();
            }
            poseStack.m_85849_();
        }
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static boolean shouldShowMarker(Entity entity) {
        LivingEntity livingEntity;
        String professionName = Markers.getProfessionName(entity);
        return professionName != "" && !entity.m_20145_() && (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6162_() && !livingEntity.m_21224_()) && !((List)MerchantMarkersConfig.getInstance().professionBlacklist.get()).contains(professionName);
    }

    public static MarkerResource getMarkerResource(Minecraft mc, String professionName, int level) {
        if (professionName == "") {
            return null;
        }
        String resourceKey = String.format("%s-%d", professionName, level);
        if (resourceCache.containsKey(resourceKey)) {
            return resourceCache.get(resourceKey);
        }
        MarkerResource result = null;
        MerchantMarkersConfig.OverlayType overlayType = MerchantMarkersConfig.OverlayType.fromValue((Integer)MerchantMarkersConfig.getInstance().overlayIndex.get()).orElse(MerchantMarkersConfig.OverlayType.NONE);
        switch (MerchantMarkersConfig.MarkerType.fromText((String)MerchantMarkersConfig.getInstance().markerType.get()).get()) {
            case ITEMS: {
                ResourceLocation associatedItemKey = MerchantMarkersConfig.getInstance().getAssociatedItem(professionName);
                if (associatedItemKey == null) break;
                Item associatedItem = (Item)ForgeRegistries.ITEMS.getValue(associatedItemKey);
                ItemRenderer itemRenderer = mc.m_91291_();
                BakedModel bakedModel = itemRenderer.m_174264_(new ItemStack((ItemLike)associatedItem), (Level)null, (LivingEntity)mc.f_91074_, 0);
                TextureAtlasSprite sprite = bakedModel.m_6160_();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.m_247685_().m_135827_(), String.format("textures/%s%s", sprite.m_247685_().m_135815_(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            case JOBS: {
                List jobBlockStates;
                VillagerProfession profession = (VillagerProfession)BuiltInRegistries.f_256735_.m_7745_(new ResourceLocation(professionName.replace("__", ":")));
                if (profession == VillagerProfession.f_35585_ || (jobBlockStates = ForgeRegistries.POI_TYPES.getValues().stream().filter(poiType -> profession.f_219629_().test((Holder)ForgeRegistries.POI_TYPES.getHolder(poiType).get())).flatMap(poiType -> poiType.f_27325_().stream()).distinct().toList()).isEmpty()) break;
                BlockRenderDispatcher blockRenderer = mc.m_91289_();
                BakedModel bakedModel = blockRenderer.m_110910_((BlockState)jobBlockStates.iterator().next());
                TextureAtlasSprite sprite = bakedModel.m_6160_();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.m_247685_().m_135827_(), String.format("textures/%s%s", sprite.m_247685_().m_135815_(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            default: {
                ResourceLocation iconResource = new ResourceLocation("merchantmarkers", String.format("textures/entity/villager/markers/%s.png", professionName));
                if (!mc.m_91098_().m_213713_(iconResource).isPresent()) break;
                result = new MarkerResource(iconResource, overlayType, level);
            }
            case GENERIC: 
        }
        if (result == null) {
            result = new MarkerResource(DEFAULT_ICON, overlayType, level);
        }
        resourceCache.put(resourceKey, result);
        return result;
    }

    private static void renderMarker(MarkerResource resource, PoseStack poseStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.getInstance().iconScale.get()).doubleValue();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        Markers.renderIcon(resource.texture(), poseStack, x, y, alpha);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            poseStack.m_252880_(0.0f, 0.0f, -1.0f);
            float imageSize = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? 32.0f : 16.0f;
            Markers.renderIcon(resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? NUMBER_OVERLAY : ICON_OVERLAY, poseStack, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize, alpha);
        });
        poseStack.m_85849_();
    }

    private static void renderArrow(PoseStack poseStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.getInstance().iconScale.get()).doubleValue();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        Markers.renderIcon(MARKER_ARROW, poseStack, x - 8, y + 8, 16, 8, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
        poseStack.m_85849_();
    }

    public static void renderOverlay(MarkerResource resource, OverlayRendererMethod method) {
        if (resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL) {
            Markers.renderOverlayLevel(resource, method);
        } else if (resource.overlay != MerchantMarkersConfig.OverlayType.NONE) {
            Markers.renderOverlayIcon(resource, method);
        }
    }

    private static void renderOverlayLevel(MarkerResource resource, OverlayRendererMethod method) {
        int processedDigits = resource.level();
        int xOffset = 8;
        while (processedDigits > 0) {
            int currentDigit = processedDigits % 10;
            method.accept(xOffset, 8, 8, 8, currentDigit % 4 * 8, currentDigit / 4 * 8);
            processedDigits /= 10;
            xOffset -= 5;
        }
    }

    private static void renderOverlayIcon(MarkerResource resource, OverlayRendererMethod method) {
        method.accept(8, 8, 8, 8, resource.overlay().value() % 2 * 8, resource.overlay().value() / 2 * 8);
    }

    private static void renderIcon(ResourceLocation icon, PoseStack poseStack, int x, int y, float alpha) {
        Markers.renderIcon(icon, poseStack, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
    }

    private static void renderIcon(ResourceLocation icon, PoseStack poseStack, int x, int y, int w, int h, float u0, float u1, float v0, float v1, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Minecraft.m_91087_().m_91097_().m_118506_(icon).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)(y + h), 0.0f).m_7421_(u0, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_7421_(u1, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + w), (float)y, 0.0f).m_7421_(u1, v0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(u0, v0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public record MarkerResource(ResourceLocation texture, MerchantMarkersConfig.OverlayType overlay, int level) {
    }

    @FunctionalInterface
    public static interface OverlayRendererMethod {
        public void accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

