/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.exception.ExceptionUtils;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.minimap.XaeroMinimap;

public class XaeroMinimapHandler
implements ResourceManagerReloadListener {
    private static XaeroMinimapHandler INSTANCE = new XaeroMinimapHandler();
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");

    public static void buildVariantIdString(StringBuilder stringBuilder, EntityRenderer<?> entityRenderer, Entity entity) {
        String profession = Markers.getProfessionName(entity);
        int professionLevel = Markers.getProfessionLevel(entity);
        if (((List)MerchantMarkersConfig.getInstance().professionBlacklist.get()).contains(profession)) {
            EntityIconDefinitions.buildVariantIdString((StringBuilder)stringBuilder, entityRenderer, (Entity)entity);
        } else {
            stringBuilder.append(profession).append("-").append(professionLevel);
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        XaeroMinimapHandler.setupDynamicIcons();
        if (XaeroMinimap.instance.getInterfaces() != null) {
            XaeroMinimap.instance.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        block13: {
            Markers.MarkerResource resource = resourceSupplier.get();
            if (resource == null) {
                return Markers.getEmptyInputStream();
            }
            if (iconCache.containsKey(resource)) {
                return new ByteArrayInputStream(iconCache.get(resource));
            }
            int innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.getInstance().minimapIconScale.get());
            int outerSize = 64;
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            BufferedImage newImage = new BufferedImage(64, 64, 2);
            Graphics2D graphics = newImage.createGraphics();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (manager.m_213713_(resource.texture()).isEmpty() && Minecraft.m_91087_().m_91097_().m_174786_(resource.texture(), null) == null) {
                return Markers.getEmptyInputStream();
            }
            if (iconOverlayImage == null) {
                iconOverlayImage = ImageIO.read(((Resource)manager.m_213713_(Markers.ICON_OVERLAY).get()).m_215507_());
            }
            if (numberOverlayImage == null) {
                numberOverlayImage = ImageIO.read(((Resource)manager.m_213713_(Markers.NUMBER_OVERLAY).get()).m_215507_());
            }
            BufferedImage originalImage = ImageIO.read(((Resource)manager.m_213713_(resource.texture()).get()).m_215507_());
            int left = (64 - innerSize) / 2;
            int right = (64 + innerSize) / 2;
            int top = (64 + innerSize) / 2;
            int bottom = (64 - innerSize) / 2;
            graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
            Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
                BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
                float scale = (float)innerSize / (float)originalImage.getWidth();
                graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
            });
            graphics.dispose();
            ByteArrayOutputStream byteArrayOutputStream = os;
            try {
                ImageIO.write((RenderedImage)newImage, "png", os);
                iconCache.put(resource, os.toByteArray());
                byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
                if (byteArrayOutputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                    iconCache.put(resource, new byte[0]);
                    return Markers.getEmptyInputStream();
                }
            }
            byteArrayOutputStream.close();
        }
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        Minecraft minecraft = Minecraft.m_91087_();
        ResourceManager manager = minecraft.m_91098_();
        if (manager instanceof ReloadableResourceManager) {
            CloseableResourceManager closeableResourceManager;
            ReloadableResourceManager reloadableManager = (ReloadableResourceManager)manager;
            Supplier<Collection> delayedResources = () -> reloadableManager.m_214159_("textures/entity/villager/markers", s -> s.toString().endsWith(".png")).keySet();
            if (!reloadableManager.f_203816_.contains(INSTANCE)) {
                reloadableManager.f_203816_.add(0, INSTANCE);
            }
            if (((Boolean)MerchantMarkersConfig.getInstance().showOnMiniMap.get()).booleanValue()) {
                int minLevel;
                int maxLevel;
                if (!MerchantMarkersConfig.getInstance().showLevels()) {
                    maxLevel = 0;
                    minLevel = 0;
                } else {
                    minLevel = 0;
                    maxLevel = 15;
                }
                dynamicPack.registerResource(PackType.CLIENT_RESOURCES, new ResourceLocation("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    for (ResourceLocation marker : (Collection)delayedResources.get()) {
                        for (int i = minLevel; i <= maxLevel; ++i) {
                            String[] components = marker.m_135815_().split("/");
                            String iconName = components[components.length - 1].replace(".png", "");
                            variants.addProperty(iconName + "-" + String.valueOf(i), "sprite:" + marker.m_135815_().replace(".png", "-" + String.valueOf(i) + ".png"));
                        }
                    }
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "com.anthonyhilyard.merchantmarkers.compat.XaeroMinimapHandler.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
                for (ResourceLocation marker : delayedResources.get()) {
                    String[] components = marker.m_135815_().split("/");
                    String iconName = components[components.length - 1].replace(".png", "");
                    for (int i = minLevel; i <= maxLevel; ++i) {
                        int level = i;
                        ResourceLocation markerLocation = new ResourceLocation("xaerominimap", "entity/icon/sprite/" + marker.m_135815_().replace(".png", "-" + String.valueOf(i) + ".png"));
                        if (minecraft.m_91097_().m_174786_(markerLocation, null) != null) {
                            minecraft.execute(() -> minecraft.m_91097_().m_118513_(markerLocation));
                        }
                        dynamicPack.registerResource(PackType.CLIENT_RESOURCES, markerLocation, () -> {
                            try {
                                InputStream proxyStream = XaeroMinimapHandler.getResizedIcon(() -> Markers.getMarkerResource(minecraft, iconName, level));
                                if (proxyStream.available() == 0) {
                                    return ((Resource)reloadableManager.m_213713_(Markers.getMarkerResource(minecraft, iconName, level).texture()).get()).m_215507_();
                                }
                                return proxyStream;
                            }
                            catch (Exception e) {
                                return Markers.getEmptyInputStream();
                            }
                        });
                    }
                }
            } else {
                dynamicPack.registerResource(PackType.CLIENT_RESOURCES, new ResourceLocation("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    variants.addProperty("default", "model");
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "xaero.common.minimap.render.radar.EntityIconDefinitions.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
            }
            if (!reloadableManager.m_7536_().anyMatch(pack -> pack.equals(dynamicPack)) && (closeableResourceManager = reloadableManager.f_203815_) instanceof MultiPackResourceManager) {
                MultiPackResourceManager resourceManager = (MultiPackResourceManager)closeableResourceManager;
                try {
                    reloadableManager.f_203815_.close();
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                reloadableManager.f_203815_ = new MultiPackResourceManager(reloadableManager.f_203817_, Stream.concat(resourceManager.m_7536_(), Stream.of(dynamicPack)).toList());
            }
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        Markers.clearResourceCache();
        XaeroMinimapHandler.clearIconCache();
    }
}

