/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import java.lang.reflect.Field;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class OptifineHandler
implements ResourceManagerReloadListener {
    private static OptifineHandler INSTANCE = new OptifineHandler();
    private static Minecraft minecraft;
    private static Boolean installed;

    public static void init() {
        minecraft = Minecraft.m_91087_();
        OptifineHandler.fixRenderSettings();
        ResourceManager resourceManager = minecraft.m_91098_();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
            resourceManager2.m_7217_((PreparableReloadListener)INSTANCE);
        }
    }

    public static boolean optifineInstalled() {
        if (installed == null) {
            installed = false;
            try {
                Class.forName("net.optifine.shaders.Shaders", false, OptifineHandler.class.getClassLoader());
                installed = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return installed;
    }

    public void m_6213_(ResourceManager resourceManager) {
        OptifineHandler.fixRenderSettings();
    }

    private static void fixRenderSettings() {
        if (!((Boolean)MerchantMarkersConfig.getInstance().enableOptifineWorkaround.get()).booleanValue()) {
            return;
        }
        try {
            String shaderPackName = (String)Class.forName("net.optifine.shaders.Shaders").getMethod("getShaderPackName", new Class[0]).invoke(null, new Object[0]);
            Field fastRenderField = Class.forName("net.minecraft.client.Options").getField("ofFastRender");
            Boolean fastRender = (Boolean)fastRenderField.get(OptifineHandler.minecraft.f_91066_);
            if (shaderPackName != null && !fastRender.booleanValue()) {
                fastRenderField.set(OptifineHandler.minecraft.f_91066_, true);
                OptifineHandler.minecraft.f_91066_.m_92169_();
                String warningMessage = I18n.m_118938_((String)"merchantmarkers.general.optifine_workaround_warning", (Object[])new Object[0]);
                if (OptifineHandler.minecraft.f_91074_ != null) {
                    OptifineHandler.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)warningMessage).m_130940_(ChatFormatting.GOLD));
                } else {
                    Loader.LOGGER.warn(warningMessage);
                }
            }
        }
        catch (Exception e) {
            Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)(e.getCause() == null ? e : e.getCause())));
        }
    }

    static {
        installed = null;
    }
}

