/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class MerchantMarkersConfig
extends IcebergConfig<MerchantMarkersConfig> {
    private static MerchantMarkersConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue alwaysShow;
    public final ForgeConfigSpec.BooleanValue showThroughWalls;
    public final ForgeConfigSpec.BooleanValue showArrow;
    public final ForgeConfigSpec.BooleanValue showOnMiniMap;
    public final ForgeConfigSpec.IntValue overlayIndex;
    public final ForgeConfigSpec.DoubleValue opacity;
    public final ForgeConfigSpec.DoubleValue maxDistance;
    public final ForgeConfigSpec.DoubleValue fadePercent;
    public final ForgeConfigSpec.DoubleValue iconScale;
    public final ForgeConfigSpec.DoubleValue minimapIconScale;
    public final ForgeConfigSpec.IntValue verticalOffset;
    public final ForgeConfigSpec.ConfigValue<? extends String> markerType;
    public final ForgeConfigSpec.ConfigValue<UnmodifiableConfig> associatedItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> professionBlacklist;
    public final ForgeConfigSpec.BooleanValue enableOptifineWorkaround;
    private static final UnmodifiableConfig defaultAssociatedItems;

    public static MerchantMarkersConfig getInstance() {
        return INSTANCE;
    }

    public MerchantMarkersConfig(IcebergConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.alwaysShow = build.comment(" If markers above villagers should always show.  If false, they will only show when the configured keybind is held.").define("always_show", true);
        this.showThroughWalls = build.comment(" If markers should be visible through walls and other obstructions.").define("show_through_walls", true);
        this.showArrow = build.comment(" If markers should include an arrow under the profession-specific icon.").define("show_arrow", true);
        this.showOnMiniMap = build.comment(" If icons should show on minimaps. (Currently supports Xaero's Minimap, FTB Chunks, and JourneyMap).").define("show_on_minimap", true);
        this.overlayIndex = build.comment(" Which overlay graphic to use (0 = backpack, 1 = emerald, 2 = coin stack, 3 = bag, 4 = profession level, -1 = none).").defineInRange("overlay_icon", 3, -1, 4);
        this.opacity = build.comment(" The opacity of displayed markers and arrows.").defineInRange("opacity", 1.0, 0.1, 1.0);
        this.maxDistance = build.comment(" The maximum distance, in blocks, at which markers are visible.").defineInRange("max_distance", 64.0, 16.0, 256.0);
        this.fadePercent = build.comment(" The percent of the maximum distance at which markers will begin to fade out.").defineInRange("fade_percent", 25.0, 0.0, 100.0);
        this.iconScale = build.comment(" How large in-world markers should appear.").defineInRange("icon_scale", 1.0, 0.5, 2.0);
        this.minimapIconScale = build.comment(" How large markers should appear on minimaps. (Only applicable for maps without a built-in icon scale option.)").defineInRange("minimap_icon_scale", 0.75, 0.5, 2.0);
        this.verticalOffset = build.comment(" How high above villagers markers should appear.  The default position (0) is right above name plates.").defineInRange("vertical_offset", 0, -128, 128);
        this.markerType = build.comment(" The types of markers to show above villagers.  Can be one of either \"items\", \"jobs\", \"generic\", or \"custom\".  These options mean:\n    \"items\" - Shows items from the associated item list below.\n    \"jobs\" - Shows the texture from the villager's job site block (like the brewing stand for clerics, and so on).\n    \"generic\" - Shows a generic icon that is the same for all villagers.\n    \"custom\" - Shows custom icons for each villager profession (these can be replaced with a resource pack).").defineInList("marker_type", (Object)"custom", Arrays.stream(MarkerType.values()).map(v -> v.name().toLowerCase()).toList());
        this.professionBlacklist = build.comment(" A list of professions to ignore when displaying markers. Use \"none\" for villagers with no profession.").define("profession_blacklist", (Object)Lists.newArrayList((Object[])new String[]{"none", "nitwit"}));
        this.associatedItems = build.comment(" The items associated with each villager profession.  Only used when marker type is set to \"items\".").defineSubconfig("associated_items", defaultAssociatedItems, k -> Objects.nonNull(k), v -> {
            String str;
            return Objects.nonNull(v) && v instanceof String && ResourceLocation.m_135830_((String)(str = (String)v));
        });
        build.pop().push("compatibility_options");
        this.enableOptifineWorkaround = build.comment(" If enabled, will force fast render on when using shaders with Optifine (due to a bug in Optifine, this is required for markers to render properly with some shaders).").define("optifine_workaround", true);
        build.pop().pop();
    }

    public boolean showLevels() {
        return OverlayType.LEVEL.equals(OverlayType.fromValue((Integer)this.overlayIndex.get()).orElse(null));
    }

    public ResourceLocation getAssociatedItem(String profession) {
        Map configuredItems = ((UnmodifiableConfig)this.associatedItems.get()).valueMap();
        if (configuredItems.containsKey(profession) && configuredItems.get(profession) instanceof String && ResourceLocation.m_135830_((String)((String)configuredItems.get(profession)))) {
            return new ResourceLocation((String)configuredItems.get(profession));
        }
        if (defaultAssociatedItems.contains(profession)) {
            return new ResourceLocation((String)defaultAssociatedItems.get(profession));
        }
        return null;
    }

    protected void onLoad() {
        Markers.clearResourceCache();
    }

    protected <I extends IcebergConfig<?>> void setInstance(I instance) {
        INSTANCE = (MerchantMarkersConfig)instance;
    }

    static {
        ForgeConfigSpec.Builder defaultAssociatedItemsBuilder = new ForgeConfigSpec.Builder();
        defaultAssociatedItemsBuilder.define("armorer", (Object)"minecraft:iron_chestplate");
        defaultAssociatedItemsBuilder.define("butcher", (Object)"minecraft:beef");
        defaultAssociatedItemsBuilder.define("cartographer", (Object)"minecraft:compass");
        defaultAssociatedItemsBuilder.define("cleric", (Object)"minecraft:rotten_flesh");
        defaultAssociatedItemsBuilder.define("farmer", (Object)"minecraft:wheat");
        defaultAssociatedItemsBuilder.define("fisherman", (Object)"minecraft:cod");
        defaultAssociatedItemsBuilder.define("fletcher", (Object)"minecraft:bow");
        defaultAssociatedItemsBuilder.define("leatherworker", (Object)"minecraft:leather");
        defaultAssociatedItemsBuilder.define("librarian", (Object)"minecraft:bookshelf");
        defaultAssociatedItemsBuilder.define("mason", (Object)"minecraft:brick");
        defaultAssociatedItemsBuilder.define("shepherd", (Object)"minecraft:shears");
        defaultAssociatedItemsBuilder.define("toolsmith", (Object)"minecraft:iron_pickaxe");
        defaultAssociatedItemsBuilder.define("weaponsmith", (Object)"minecraft:iron_sword");
        defaultAssociatedItemsBuilder.define("wandering_trader", (Object)"minecraft:emerald");
        defaultAssociatedItems = defaultAssociatedItemsBuilder.build();
    }

    public static enum MarkerType {
        ITEMS,
        JOBS,
        GENERIC,
        CUSTOM;


        public static Optional<MarkerType> fromText(String text) {
            return Arrays.stream(MarkerType.values()).filter(v -> v.name().equalsIgnoreCase(text)).findFirst();
        }
    }

    public static enum OverlayType {
        NONE(-1),
        BACKPACK(0),
        EMERALD(1),
        COINS(2),
        BAG(3),
        LEVEL(4);

        private final int value;

        private OverlayType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Optional<OverlayType> fromValue(int value) {
            return Arrays.stream(OverlayType.values()).filter(v -> v.value == value).findFirst();
        }
    }
}

