/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.TargetPhase;
import nonamecrackers2.endertrigon.common.init.EnderTrigonDragonPhases;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonChargeUpPhase
extends AbstractDragonSittingPhase {
    private static final Logger LOGGER = LogManager.getLogger((String)"endertrigon/DragonChargeUpPhase");
    private static final int CHARGE_UP_TIME = 50;
    private static final TargetingConditions CHARGE_TARGETING = TargetingConditions.m_148352_();
    private int chargeUpTicks;
    @Nullable
    private AttackType previousAttack;

    public DragonChargeUpPhase(EnderDragon dragon) {
        super(dragon);
    }

    public void m_6991_() {
        this.f_31176_.m_9236_().m_7785_(this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_(), SoundEvents.f_11894_, this.f_31176_.m_5720_(), 10.0f, 0.8f + this.f_31176_.m_217043_().m_188501_() * 0.3f, false);
    }

    public void m_6989_() {
        BlockPos pos = this.f_31176_.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)BlockPos.f_121853_));
        Player player = this.f_31176_.m_9236_().m_45949_(CHARGE_TARGETING, (LivingEntity)this.f_31176_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ++this.chargeUpTicks;
        if (this.chargeUpTicks > 50) {
            AttackType type = AttackType.random(this.f_31176_.m_217043_(), this.previousAttack);
            if (player != null && type != null) {
                type.activate(this.f_31176_.m_31157_(), (LivingEntity)player);
                this.previousAttack = type;
            } else {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            }
        } else if (player != null) {
            double x = player.m_20185_() - this.f_31176_.m_20185_();
            double z = player.m_20189_() - this.f_31176_.m_20189_();
            float yRot = (float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) + 90.0f;
            this.f_31176_.m_146922_(yRot);
        }
    }

    public void m_7083_() {
        this.chargeUpTicks = 0;
    }

    public EnderDragonPhase<DragonChargeUpPhase> m_7309_() {
        return EnderTrigonDragonPhases.getPhase("ChargeUp").get();
    }

    public static enum AttackType {
        SNATCH_PLAYER("SnatchPlayer"),
        CRASH_PLAYER("CrashPlayer"),
        DIVE_BOMB_PLAYER("DiveBombPlayer");

        private final String customPhaseId;

        private AttackType(String customPhaseId) {
            this.customPhaseId = customPhaseId;
        }

        public void activate(EnderDragonPhaseManager manager, LivingEntity target) {
            EnderDragonPhase phase = EnderTrigonDragonPhases.getPhase(this.customPhaseId).get();
            manager.m_31416_(phase);
            DragonPhaseInstance instance = manager.m_31418_(phase);
            if (instance instanceof TargetPhase) {
                TargetPhase targetable = (TargetPhase)instance;
                targetable.setTarget(target);
            }
        }

        @Nullable
        public static AttackType random(RandomSource random, @Nullable AttackType toExclude) {
            AttackType[] types = AttackType.values();
            for (AttackType type : AttackType.values()) {
                if (EnderTrigonDragonPhases.isEnabled(type.customPhaseId)) continue;
                types = (AttackType[])ArrayUtils.removeElement((Object[])types, (Object)((Object)type));
            }
            LOGGER.debug("Available attacks: ");
            for (AttackType type : types) {
                LOGGER.debug((Object)type);
            }
            if (toExclude != null && types.length > 1) {
                types = (AttackType[])ArrayUtils.removeElement((Object[])types, (Object)((Object)toExclude));
            }
            if (types.length == 1) {
                return types[0];
            }
            if (types.length > 1) {
                return (AttackType)((Object)Util.m_214670_((Object[])types, (RandomSource)random));
            }
            return null;
        }
    }
}

