/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin.malformedtraffic;

import com.connectivity.networkstats.MalformedTrafficTracker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.nio.channels.ClosedChannelException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/server/network/ServerConnectionListener$1"})
public class ChannelHandler {
    @Inject(method={"initChannel"}, at={@At(value="RETURN")})
    private void injectEarlyHandler(Channel channel, CallbackInfo ci) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("malformed_ip_blocker", (io.netty.channel.ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                MalformedTrafficTracker.ACTIVE_CHANNELS.decrementAndGet();
                super.channelInactive(ctx);
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                MalformedTrafficTracker.ACTIVE_CHANNELS.incrementAndGet();
                MalformedTrafficTracker.removedBlocked(ctx.channel().toString());
                if (MalformedTrafficTracker.isBlocked(ctx)) {
                    MalformedTrafficTracker.freezeChannel(ctx, MalformedTrafficTracker.freezeTimeoutSeconds());
                    return;
                }
                super.channelActive(ctx);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                block3: {
                    if (MalformedTrafficTracker.isBlocked(ctx)) {
                        return;
                    }
                    try {
                        super.channelRead(ctx, msg);
                    }
                    catch (Exception e) {
                        MalformedTrafficTracker.recordError(ctx);
                        if (MalformedTrafficTracker.isBlocked(ctx)) break block3;
                        throw e;
                    }
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                if (MalformedTrafficTracker.isBlocked(ctx)) {
                    return;
                }
                if (!(cause instanceof ClosedChannelException)) {
                    MalformedTrafficTracker.recordError(ctx);
                }
                ctx.fireExceptionCaught(cause);
            }
        });
    }
}

