/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import plus.dragons.createcentralkitchen.foundation.config.CentralKitchenCommonConfig;
import plus.dragons.createcentralkitchen.foundation.config.CentralKitchenConfigBase;

@Mod.EventBusSubscriber(modid="create_central_kitchen", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CentralKitchenConfigs {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"CONFIG");
    private static final Map<IConfigSpec<?>, CentralKitchenConfigBase> CONFIGS = new HashMap();
    public static CentralKitchenCommonConfig COMMON;
    public static ForgeConfigSpec COMMON_SPEC;

    public static void register(ModLoadingContext context) {
        ModContainer container = context.getActiveContainer();
        ModConfig common = new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, container);
        container.addConfig(common);
        CentralKitchenConfigs.earlyLoadConfig(COMMON, COMMON_SPEC, container, common);
    }

    private static void earlyLoadConfig(CentralKitchenConfigBase object, ForgeConfigSpec spec, ModContainer container, ModConfig config) {
        LOGGER.trace(MARKER, "Early Loading config file type {} at {} for {}", (Object)config.getType(), (Object)config.getFileName(), (Object)config.getModId());
        CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(FMLPaths.CONFIGDIR.get()).apply(config);
        spec.acceptConfig((CommentedConfig)configData);
        object.onLoad();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (CONFIGS.containsKey(spec)) {
            CONFIGS.get(spec).onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (CONFIGS.containsKey(spec)) {
            CONFIGS.get(spec).onReload();
        }
    }

    static {
        Pair commonConfig = new ForgeConfigSpec.Builder().configure(builder -> {
            CentralKitchenCommonConfig config = new CentralKitchenCommonConfig();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        COMMON = (CentralKitchenCommonConfig)((Object)commonConfig.getKey());
        COMMON_SPEC = (ForgeConfigSpec)commonConfig.getValue();
        CONFIGS.put((IConfigSpec<?>)COMMON_SPEC, COMMON);
    }
}

