/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CapturedExpression;
import org.openzen.zenscript.codemodel.expression.CapturedLocalVariableExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.expression.LambdaClosure;
import org.openzen.zenscript.codemodel.expression.SetLocalVariableExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.statement.VarStatement;

public class GetLocalVariableExpression
extends Expression {
    public final VarStatement variable;

    public GetLocalVariableExpression(CodePosition position, VarStatement variable) {
        super(position, variable.type, null);
        this.variable = variable;
    }

    @Override
    public Expression assign(CodePosition position, TypeScope scope, Expression value) {
        return new SetLocalVariableExpression(position, this.variable, value.castImplicit(position, scope, this.type));
    }

    @Override
    public CapturedExpression capture(CodePosition position, LambdaClosure closure) {
        CapturedLocalVariableExpression result = new CapturedLocalVariableExpression(position, this.variable, closure);
        closure.add(result);
        return result;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitGetLocalVariable(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitGetLocalVariable(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        return this;
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return this;
    }
}

