/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ByteArrayData")
@ZenRegister
@Document(value="vanilla/api/data/ByteArrayData")
public class ByteArrayData
implements IData {
    private final ByteArrayTag internal;

    public ByteArrayData(ByteArrayTag internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ByteArrayData(byte[] internal) {
        this.internal = new ByteArrayTag(internal);
    }

    @Override
    public void put(String index, IData value) {
        try {
            this.getInternal().m_7615_(Integer.parseInt(index), (Tag)ByteTag.m_128266_((byte)value.asByte()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Provided index: '%s' is not an Integer!".formatted(index));
        }
    }

    @Override
    public IData getAt(int index) {
        return TagToDataConverter.convert((Tag)this.getInternal().get(index));
    }

    @Override
    public void remove(int index) {
        this.getInternal().remove(index);
    }

    @Override
    public boolean contains(IData other) {
        if (other.isListable()) {
            List<IData> dataValues = other.asList();
            return dataValues != null && this.containsList(dataValues);
        }
        return this.getInternal().contains((Object)ByteTag.m_128266_((byte)other.asByte()));
    }

    @Override
    public int compareTo(@NotNull IData other) {
        return Arrays.compare(this.asByteArray(), other.asByteArray());
    }

    @Override
    public boolean equalTo(IData other) {
        return Arrays.equals(this.asByteArray(), other.asByteArray());
    }

    @Override
    public List<IData> asList() {
        return this.getInternal().stream().map(ByteData::new).collect(Collectors.toList());
    }

    @Override
    public boolean isListable() {
        return true;
    }

    @Override
    public byte[] asByteArray() {
        return this.getInternal().m_128227_();
    }

    @Override
    public int[] asIntArray() {
        byte[] bytes = this.asByteArray();
        int[] ints = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ints[i] = bytes[i];
        }
        return ints;
    }

    @Override
    public long[] asLongArray() {
        byte[] bytes = this.asByteArray();
        long[] longs = new long[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            longs[i] = bytes[i];
        }
        return longs;
    }

    @Override
    public int length() {
        return this.getInternal().size();
    }

    @Override
    @NotNull
    public Iterator<IData> iterator() {
        return this.asList().iterator();
    }

    public ByteArrayTag getInternal() {
        return this.internal;
    }

    @Override
    public ByteArrayData copy() {
        return new ByteArrayData(this.getInternal());
    }

    @Override
    public ByteArrayData copyInternal() {
        return new ByteArrayData((ByteArrayTag)this.getInternal().m_6426_());
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitByteArray(this);
    }

    @Override
    public IData.Type getType() {
        return IData.Type.BYTE_ARRAY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayData iData = (ByteArrayData)o;
        return Objects.equals(this.getInternal(), iData.getInternal());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal());
    }

    public String toString() {
        return this.getAsString();
    }
}

