/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe;

import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.function.Function;
import net.minecraft.world.item.crafting.Recipe;

public class ActionAddRecipe<T extends Recipe<?>>
extends ActionRecipeBase<T> {
    protected final T recipe;
    private final String subType;
    private Function<T, String> describeOutputsFunction;

    public ActionAddRecipe(IRecipeManager<T> recipeManager, T recipe, String subType) {
        super(recipeManager);
        this.recipe = recipe;
        this.subType = subType;
        this.describeOutputsFunction = r -> ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((Recipe)r).m_8043_(arg_0)));
    }

    public ActionAddRecipe(IRecipeManager<T> recipeManager, T recipe) {
        this(recipeManager, recipe, "");
    }

    @Override
    public void apply() {
        this.getRecipeMutator().add(this.recipe.m_6423_(), this.recipe);
    }

    @Override
    public String describe() {
        return "Adding '%s' recipe%s, with name: '%s' that outputs: '%s'".formatted(this.getManager().getBracketResourceLocation(), this.getSubTypeDescription(), this.recipe.m_6423_(), this.describeOutputsFunction.apply(this.recipe));
    }

    public ActionAddRecipe<T> outputDescriber(Function<T, String> describeOutputsFunction) {
        this.describeOutputsFunction = describeOutputsFunction;
        return this;
    }

    private String getSubTypeDescription() {
        if (this.subType != null && !this.subType.isBlank()) {
            return ", of type: \"" + this.subType + "\"";
        }
        return "";
    }
}

