/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.undergarden;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class BlisterberryFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return UGBlocks.BLISTERBERRY_BUSH.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)UGBlocks.BLISTERBERRY_BUSH.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)UGItems.BLISTERBERRY.get()), new ItemStack((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == UGBlocks.BLISTERBERRY_BUSH.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)BlisterberryBushBlock.AGE) > 1;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)BlisterberryBushBlock.AGE) == 3;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            Integer age = (Integer)state.m_61143_((Property)BlisterberryBushBlock.AGE);
            boolean flag = age == 3;
            int random = 1 + level.m_213780_().m_188503_(2);
            int random2 = level.m_213780_().m_188503_(2);
            BlockState newState = (BlockState)state.m_61124_((Property)BlisterberryBushBlock.AGE, (Comparable)Integer.valueOf(1));
            level.m_7731_(context.getPosition(), newState, 2);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((ItemLike)UGItems.BLISTERBERRY.get(), random + (flag ? 1 : 0)));
            drops.add(new ItemStack((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), random2 + (flag ? 1 : 0)));
            return drops;
        }
        return Collections.emptyList();
    }
}

