/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tconstruct;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import steve_gall.minecolonies_compatibility.core.common.inventory.EmptyMenu;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.TConstructModule;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.TConstructToolSystem;

public class TConstructToolHelper {
    public static boolean isToolAndBroken(ItemStack stack) {
        TConstructToolSystem system = TConstructToolSystem.INSTANCE;
        return system.isTool(stack) && system.isBroken(stack);
    }

    public static List<MaterialVariantId> getRepairVariantIds(IToolStackView tool) {
        return TConstructToolHelper.getRepairVariants(tool).stream().map(v -> v.getVariant()).toList();
    }

    public static List<MaterialVariant> getRepairVariants(IToolStackView tool) {
        MaterialNBT materials = tool.getMaterials();
        List components = ToolMaterialHook.stats((ToolDefinition)tool.getDefinition());
        HashSet<String> variantIds = new HashSet<String>();
        ArrayList<MaterialVariant> variants = new ArrayList<MaterialVariant>();
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (int i = 0; i < components.size(); ++i) {
            MaterialVariant variant;
            MaterialVariantId variantId;
            if (i >= materials.size() || !registry.canRepair((MaterialStatsId)components.get(i)) || IMaterial.UNKNOWN_ID.equals((Object)(variantId = (variant = materials.get(i)).getVariant())) || !variantIds.add(variantId.toString())) continue;
            variants.add(variant);
        }
        return variants;
    }

    public static ItemStack repair(ItemStack tool, ItemStack repairKit, RegistryAccess registryAccess) {
        TransientCraftingContainer container = new TransientCraftingContainer((AbstractContainerMenu)EmptyMenu.INSTANCE, 1, 2);
        container.m_6836_(0, tool);
        container.m_6836_(1, repairKit);
        return TConstructModule.REPAIR_RECIPE.assemble((CraftingContainer)container, registryAccess);
    }

    public static int getRepairCount(ItemStack tool, MaterialVariantId variantId, RegistryAccess registryAccess) {
        ItemStack repairKit = ((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterial(variantId);
        return TConstructToolHelper.getRepairCount(tool, repairKit, registryAccess);
    }

    public static int getRepairCount(ItemStack tool, ItemStack repairKit, RegistryAccess registryAccess) {
        int oldDamage = ToolStack.from((ItemStack)tool).getDamage();
        int i = 0;
        while (oldDamage != 0) {
            int newDamage = ToolStack.from((ItemStack)(tool = TConstructToolHelper.repair(tool, repairKit, registryAccess))).getDamage();
            if (oldDamage == newDamage) {
                return i;
            }
            oldDamage = newDamage;
            ++i;
        }
        return i;
    }

    public static boolean canRepair(ItemStack tool) {
        return ToolStack.from((ItemStack)tool).getDamage() > 0;
    }

    private TConstructToolHelper() {
    }
}

