/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tacz.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostSlot;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.ContainerHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.tacz.init.ModuleMenuTypes;

public class GunSmithTableTeachMenu
extends TeachRecipeMenu<GunSmithTableRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 9;
    public static final int CRAFTING_X = 98;
    public static final int CRAFTING_Y = 17;
    public static final int CRAFTING_COLUMNS = 3;
    public static final int CRAFTING_ROW = 3;
    public static final int RESULT_X = 44;
    public static final int RESULT_Y = 35;

    public GunSmithTableTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.TACZ_GUN_SMITH_TABLE_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public GunSmithTableTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.TACZ_GUN_SMITH_TABLE_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 9);
        for (int i = 0; i < 9; ++i) {
            int x = i % 3;
            int y = i / 3;
            this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, i, 98 + x * 18, 17 + y * 18)));
        }
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.m_38897_(new ResultSlot(this.resultContainer, 0, 44, 35)));
    }

    @Override
    protected IMenuRecipeValidator<GunSmithTableRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<GunSmithTableRecipe, Inventory>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<GunSmithTableRecipe> getRecipeType() {
                return (RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get();
            }

            @Override
            protected boolean test(GunSmithTableRecipe recipe, Container container, ServerPlayer player) {
                List inputs = recipe.getInputs();
                List<ItemStack> stacks = ItemStackHelper.filterNotEmpty(ContainerHelper.getItemStacks(container));
                if (inputs.size() != stacks.size()) {
                    return false;
                }
                ArrayList<ItemStack> remainedStacks = new ArrayList<ItemStack>(stacks);
                for (GunSmithTableIngredient input : inputs) {
                    int found = -1;
                    for (int i = 0; i < remainedStacks.size(); ++i) {
                        ItemStack stack = remainedStacks.get(i);
                        if (!input.getIngredient().test(stack)) continue;
                        found = i;
                        remainedStacks.remove(i);
                        break;
                    }
                    if (found != -1) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull GunSmithTableRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        List<ItemStack> input = NBTUtils2.deserializeList(payload, "input", ItemStack::m_41712_);
        for (ItemStack stack : input) {
            stack.m_41764_(1);
        }
        for (int i = 0; i < 9; ++i) {
            this.inputContainer.m_6836_(i, i < input.size() ? input.get(i) : ItemStack.f_41583_);
        }
    }

    @Override
    protected void onSlotsChanged(Container container) {
        if (container == this.inputContainer) {
            return;
        }
        super.onSlotsChanged(container);
    }

    @Override
    public void handleSlotClick(Slot slot, ItemStack stack) {
        if (slot.f_40218_ == this.inputContainer) {
            if (this.recipe != null) {
                GunSmithTableIngredient input;
                List inputs = ((GunSmithTableRecipe)this.recipe).getInputs();
                int index = this.inputSlots.indexOf(slot);
                if (0 <= index && index < inputs.size() && (input = (GunSmithTableIngredient)inputs.get(index)).getIngredient().test(stack)) {
                    stack = stack.m_41777_();
                    stack.m_41764_(input.getCount());
                    slot.m_5852_(stack);
                }
            }
            return;
        }
        if (slot.f_40218_ == this.resultContainer) {
            Player player = this.inventory.f_35978_;
            List recipes = player.m_9236_().m_7465_().m_44013_((RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get());
            for (GunSmithTableRecipe recipe : recipes) {
                if (!this.test(stack, recipe)) continue;
                this.recipe = recipe;
                this.onRecipeChanged(this.inventory.f_35978_.m_9236_().m_9598_());
                this.refreshRecipes(recipe);
                break;
            }
            return;
        }
        super.handleSlotClick(slot, stack);
    }

    private boolean test(ItemStack stack, GunSmithTableRecipe recipe) {
        ItemStack result = recipe.getResult().getResult();
        Item item = result.m_41720_();
        if (item == stack.m_41720_()) {
            if (item instanceof IGun) {
                IGun gun = (IGun)item;
                return gun.getGunId(stack).equals((Object)gun.getGunId(result));
            }
            if (item instanceof IAttachment) {
                IAttachment attachment = (IAttachment)item;
                return attachment.getAttachmentId(stack).equals((Object)attachment.getAttachmentId(result));
            }
            if (item instanceof IAmmo) {
                IAmmo ammo = (IAmmo)item;
                return ammo.getAmmoId(stack).equals((Object)ammo.getAmmoId(result));
            }
        }
        return false;
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        if (this.recipe != null) {
            this.resultContainer.m_6836_(0, ((GunSmithTableRecipe)this.recipe).m_8043_(registryAccess));
            List inputs = ((GunSmithTableRecipe)this.recipe).getInputs();
            for (int i = 0; i < this.inputContainer.m_6643_(); ++i) {
                if (i < inputs.size()) {
                    ItemStack stack = this.inputContainer.m_8020_(i);
                    GunSmithTableIngredient input = (GunSmithTableIngredient)inputs.get(i);
                    if (!input.getIngredient().test(stack)) {
                        ItemStack[] examples = input.getIngredient().m_43908_();
                        stack = examples.length == 0 ? ItemStack.f_41583_ : examples[0].m_41777_();
                        this.inputContainer.m_6836_(i, stack);
                    }
                    stack.m_41764_(input.getCount());
                    continue;
                }
                this.inputContainer.m_6836_(i, ItemStack.f_41583_);
            }
        } else {
            this.resultContainer.m_6836_(0, ItemStack.f_41583_);
            this.inputContainer.m_6211_();
        }
    }

    private class ResultSlot
    extends TeachResultSlot
    implements IItemGhostSlot {
        public ResultSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }
    }
}

