/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.storagenetwork;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.IConnectableLink;
import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.minecolonies.api.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackCounter;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;
import steve_gall.minecolonies_compatibility.mixin.common.storagenetwork.NetworkModuleAccessor;
import steve_gall.minecolonies_compatibility.module.common.storagenetwork.init.ModuleBlockEntities;
import steve_gall.minecolonies_compatibility.module.common.storagenetwork.init.ModuleItems;

public class CitizenInventoryBlockEntity
extends TileConnectable
implements INetworkStorageViewHolder,
IAccessDirectionHolder {
    private static final String TAG_LINK = "link";
    private static final String TAG_WAY = "way";
    private final StorageView view;
    private final ItemStackCounter counter;
    private AccessDirection accessDirection = AccessDirection.INSERT_EXTRACT;

    public CitizenInventoryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModuleBlockEntities.CITIZEN_INVENTORY.get(), pos, state);
        this.view = new StorageView();
        this.counter = new ItemStackCounter();
        this.counter.addListener(this::onCounterChanged);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> arg0, Direction arg1) {
        LazyOptional cap = super.getCapability(arg0, arg1);
        return cap;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.view.readLink(compound.m_128469_(TAG_LINK));
        this.accessDirection = AccessDirection.deserialize(compound.m_128423_(TAG_WAY));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_(TAG_LINK, (Tag)this.view.writeLink());
        compound.m_128365_(TAG_WAY, this.accessDirection.serialize());
    }

    public void m_6596_() {
        Level level = this.m_58904_();
        if (level != null) {
            WorldUtil.markChunkDirty((Level)level, (BlockPos)this.m_58899_());
        }
        super.m_6596_();
    }

    protected void onTick() {
        Level level = this.m_58904_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_46467_() % (long)StorageNetworkMod.CONFIG.refreshTicks() == 0L) {
            this.update();
        }
        this.view.onTick();
    }

    public void update() {
        Iterable<Object2LongMap.Entry<ItemStackKey>> stacks = this.getStacks();
        this.counter.replace(stacks);
    }

    private void onCounterChanged(ItemStackKey key, long oldCount, long newCount) {
        if (oldCount < newCount) {
            this.view.enqueue(key.getStack(newCount));
        }
    }

    private Iterable<Object2LongMap.Entry<ItemStackKey>> getStacks() {
        TileMain main = this.getMainBlockEntity();
        if (main == null) {
            return Collections.emptyList();
        }
        boolean isFiltered = true;
        ItemStackCounter counter = new ItemStackCounter();
        main.getNetwork().setShouldRefresh();
        try {
            Set<IConnectableLink> links = ((NetworkModuleAccessor)main.getNetwork()).invokeGetConnectableStorage();
            for (IConnectableLink link : links) {
                for (ItemStack stack : link.getStoredStacks(isFiltered)) {
                    if (stack == null || stack.m_41619_()) continue;
                    ItemStackKey key = new ItemStackKey(stack);
                    counter.insert(key, stack.m_41613_());
                }
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        return counter.entrySet();
    }

    public TileMain getMainBlockEntity() {
        DimPos mainPos = this.getMain();
        if (mainPos != null) {
            return (TileMain)mainPos.getTileEntity(TileMain.class);
        }
        return null;
    }

    @Override
    @NotNull
    public INetworkStorageView getNetworkStorageView() {
        return this.view;
    }

    @Override
    public AccessDirection getAccessDirection() {
        return this.accessDirection;
    }

    @Override
    public void setAccessDirection(AccessDirection value) {
        if (this.accessDirection != value) {
            this.accessDirection = value;
            this.view.requestAll();
            this.m_6596_();
        }
    }

    public static <BLOCK_ENTITY extends CitizenInventoryBlockEntity> void tick(Level level, BlockPos pos, BlockState state, BLOCK_ENTITY blockEntity) {
        blockEntity.onTick();
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CitizenInventoryBlockEntity.this.f_58857_;
        }

        @Override
        public BlockPos getPos() {
            return CitizenInventoryBlockEntity.this.f_58858_;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)ModuleItems.CITIZEN_INVENTORY.get());
        }

        @Override
        public boolean isActive() {
            return CitizenInventoryBlockEntity.this.getMainBlockEntity() != null;
        }

        @Override
        public boolean canExtract() {
            return CitizenInventoryBlockEntity.this.getAccessDirection().canExtract();
        }

        @Override
        public boolean canInsert() {
            return CitizenInventoryBlockEntity.this.getAccessDirection().canInsert();
        }

        @Override
        @NotNull
        public Stream<ItemStack> getAllStacks() {
            return CitizenInventoryBlockEntity.this.counter.entrySet().stream().map(e -> ((ItemStackKey)e.getKey()).getStack(e.getLongValue()));
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CitizenInventoryBlockEntity.this.m_6596_();
        }

        @Override
        public void unlink() {
            super.unlink();
            CitizenInventoryBlockEntity.this.m_6596_();
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, boolean simulate) {
            TileMain main = CitizenInventoryBlockEntity.this.getMainBlockEntity();
            if (main == null) {
                return ItemStack.f_41583_;
            }
            return main.request(new ItemStackMatcher(stack), stack.m_41613_(), simulate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
            TileMain main = CitizenInventoryBlockEntity.this.getMainBlockEntity();
            if (main == null) {
                return stack;
            }
            int remainedCount = main.insertStack(stack, simulate);
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(remainedCount);
            return copy;
        }
    }
}

