/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.reliquary;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import reliquary.init.ModItems;
import reliquary.item.MagazineItem;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class Magazine
implements IDeliverableObject {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("reliquary_magazine");
    public static final Component SHORT_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("reliquary_magazine"));
    public static final Component LONG_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("reliquary_magazine.desc"));
    private static List<ItemStack> MAGAZINE_EXAMPLES = null;
    private final int minCount;

    public Magazine(int minCount) {
        this.minCount = minCount;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    public static Magazine deserialize(IFactoryController controller, CompoundTag tag) {
        int minCount = tag.m_128451_("minCount");
        return new Magazine(minCount);
    }

    public static void serialize(IFactoryController controller, CompoundTag tag, Magazine request) {
        tag.m_128405_("minCount", request.minCount);
    }

    @NotNull
    public Component getShortDisplayString() {
        return SHORT_DISPLAY_STRING;
    }

    @NotNull
    public Component getLongDisplayString() {
        return LONG_DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (MAGAZINE_EXAMPLES == null) {
            MAGAZINE_EXAMPLES = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(this::matches).toList();
        }
        return MAGAZINE_EXAMPLES;
    }

    public Magazine copyWithCount(int newCount) {
        return new Magazine(this.minCount);
    }

    public int getCount() {
        return 64;
    }

    public int getMinimumCount() {
        return this.minCount;
    }

    public boolean matches(@NotNull ItemStack stack) {
        MagazineItem item;
        Item item2 = stack.m_41720_();
        return item2 instanceof MagazineItem && (item = (MagazineItem)item2) != ModItems.EMPTY_MAGAZINE.get();
    }
}

