/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.polymorph;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.client.base.IPolymorphClient;
import com.illusivesoulworks.polymorph.api.client.base.IRecipesWidget;
import com.illusivesoulworks.polymorph.api.client.widget.AbstractRecipesWidget;
import com.illusivesoulworks.polymorph.common.impl.RecipePair;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.client.gui.containers.WindowCrafting;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fml.loading.FMLEnvironment;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuSelectMessage;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class PolymorphModule
extends AbstractModule {
    @Override
    protected void onLoad() {
        super.onLoad();
        if (FMLEnvironment.dist.isClient()) {
            PolymorphApi.client().registerWidget(new IPolymorphClient.IRecipesWidgetFactory(){

                public IRecipesWidget createWidget(AbstractContainerScreen<?> screen) {
                    if (screen instanceof WindowCrafting) {
                        return new AbstractRecipesWidget(screen){

                            public Slot getOutputSlot() {
                                AbstractContainerMenu menu = this.containerScreen.m_6262_();
                                return menu.m_38853_(0);
                            }

                            public void selectRecipe(ResourceLocation id) {
                                MineColoniesCompatibility.network().sendToServer((AbstractMessage)new TeachRecipeMenuSelectMessage(id));
                            }
                        };
                    }
                    if (screen instanceof TeachRecipeScreen) {
                        return new AbstractRecipesWidget(screen){

                            public Slot getOutputSlot() {
                                TeachRecipeMenu menu = (TeachRecipeMenu)this.containerScreen.m_6262_();
                                return menu.getResultSlots().get(0);
                            }

                            public void selectRecipe(ResourceLocation id) {
                                MineColoniesCompatibility.network().sendToServer((AbstractMessage)new TeachRecipeMenuSelectMessage(id));
                            }

                            public int getXPos() {
                                return ((TeachRecipeScreen)this.containerScreen).getSwitchButtonX();
                            }

                            public int getYPos() {
                                return ((TeachRecipeScreen)this.containerScreen).getSwitchButtonY();
                            }
                        };
                    }
                    return null;
                }
            });
        }
    }

    public static void sendRecipesList(ServerPlayer player, List<Tuple<CraftingRecipe, ItemStack>> tuples, ItemStack current) {
        TreeSet<RecipePair> pairs = new TreeSet<RecipePair>();
        ResourceLocation selected = null;
        for (Tuple<CraftingRecipe, ItemStack> tuple : tuples) {
            ResourceLocation id = ((CraftingRecipe)tuple.getA()).m_6423_();
            ItemStack stack = (ItemStack)tuple.getB();
            if (stack.m_41619_()) continue;
            pairs.add(new RecipePair(id, stack));
            if (!ItemStackHelper.equals(current, stack)) continue;
            selected = id;
        }
        PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(player, pairs, selected);
    }

    public static <RECIPE> void sendRecipesList(ServerPlayer player, TeachRecipeMenu<RECIPE> menu) {
        IMenuRecipeValidator<RECIPE> recipeValidator = menu.getRecipeValidator();
        if (recipeValidator instanceof MenuRecipeValidatorRecipe) {
            TreeSet<RecipePair> pairs = new TreeSet<RecipePair>();
            ResourceLocation selected = null;
            List<RECIPE> recipes = menu.getRecipes();
            RegistryAccess registryAccess = menu.getInventory().f_35978_.m_9236_().m_9598_();
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                ItemStack result = recipe.m_8043_(registryAccess);
                if (result.m_41619_()) continue;
                pairs.add(new RecipePair(recipe.m_6423_(), result));
                if (menu.getRecipeIndex() != i) continue;
                selected = recipe.m_6423_();
            }
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(player, pairs, selected);
        }
    }

    public static void sendHighlightRecipe(ServerPlayer player, ResourceLocation recipeId) {
        PolymorphApi.common().getPacketDistributor().sendHighlightRecipeS2C(player, recipeId);
    }
}

