/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.neapolitan;

import com.teamabnormals.neapolitan.common.block.StrawberryBushBlock;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;

public class StrawBerryCrop
extends CustomizedCrop {
    @Override
    public boolean isSeed(@NotNull PlantSeedContext context) {
        return context.getSeed().m_150930_((Item)NeapolitanItems.STRAWBERRY_PIPS.get());
    }

    @Override
    public boolean isCrop(@NotNull PlantBlockContext context) {
        return context.getState().m_60713_((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get());
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return this::getHarvestPosition;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return this::harvest;
    }

    @Nullable
    private BlockPos getHarvestPosition(@NotNull PlantBlockContext context) {
        StrawberryBushBlock block;
        BlockState state = context.getState();
        Block block2 = state.m_60734_();
        if (block2 instanceof StrawberryBushBlock && (block = (StrawberryBushBlock)block2).isMaxAge(state)) {
            return context.getPosition();
        }
        return null;
    }

    private List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            int count = 1 + level.f_46441_.m_188503_(2);
            Item item = state.m_61143_((Property)StrawberryBushBlock.TYPE) == StrawberryBushBlock.StrawberryType.WHITE ? (Item)NeapolitanItems.WHITE_STRAWBERRIES.get() : (Item)NeapolitanItems.STRAWBERRIES.get();
            level.m_7731_(context.getPosition(), (BlockState)((BlockState)state.m_61124_((Property)StrawberryBushBlock.AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)StrawberryBushBlock.TYPE, (Comparable)StrawberryBushBlock.StrawberryType.NONE), 2);
            return Collections.singletonList(new ItemStack((ItemLike)item, count));
        }
        return Collections.emptyList();
    }
}

