/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.meadow.core.recipes.CheeseFormRecipe;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.lets_do_meadow.init.ModuleMenuTypes;

public class CheeseTeachMenu
extends TeachRecipeMenu<CheeseFormRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 2;
    public static final int CRAFTING_X = 44;
    public static final int CRAFTING_Y = 26;
    public static final int CRAFTING_COLUMNS = 3;
    public static final int CRAFTING_ROW = 2;
    public static final int RESULT_X = 130;
    public static final int RESULT_Y = 26;

    public CheeseTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.CHEESE_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public CheeseTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.CHEESE_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 2);
        for (int i = 0; i < 2; ++i) {
            this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, i, 44 + i * 18, 26)));
        }
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 0, 130, 26)));
    }

    @Override
    protected IMenuRecipeValidator<CheeseFormRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CheeseFormRecipe, Container>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<CheeseFormRecipe> getRecipeType() {
                return (RecipeType)RecipeRegistry.CHEESE.get();
            }

            @Override
            protected boolean test(CheeseFormRecipe recipe, Container container, ServerPlayer player) {
                return this.matchesWithIngredientsCount(recipe, new CompoundContainer((Container)new SimpleContainer(1), container));
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull CheeseFormRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        List<ItemStack> input = NBTUtils2.deserializeList(payload, "input", ItemStack::m_41712_);
        for (int i = 0; i < 2; ++i) {
            this.inputContainer.m_6836_(i, i < input.size() ? input.get(i) : ItemStack.f_41583_);
        }
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        this.resultContainer.m_6836_(0, this.recipe != null ? ((CheeseFormRecipe)this.recipe).m_8043_(registryAccess) : ItemStack.f_41583_);
    }
}

