/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.fruitsdelight;

import dev.xkmc.fruitsdelight.content.block.BaseBushBlock;
import dev.xkmc.fruitsdelight.content.block.DoubleFruitBushBlock;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class FruitBushFruit
extends CustomizedFruit {
    private final BushBlock bush;
    private final Item fruit;
    private final ResourceLocation id;
    private final List<ItemStack> blockIcons;
    private final List<ItemStack> itemIcons;

    public FruitBushFruit(FDBushes bush) {
        this(bush.getBush(), bush.getSeed(), bush.getFruit());
    }

    public FruitBushFruit(BushBlock bush, Item seed, Item fruit) {
        this.bush = bush;
        this.fruit = fruit;
        this.id = ForgeRegistries.BLOCKS.getKey((Object)bush);
        this.blockIcons = Arrays.asList(new ItemStack((ItemLike)seed));
        this.itemIcons = Arrays.asList(new ItemStack((ItemLike)fruit));
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return this.blockIcons;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60713_((Block)this.bush);
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)BaseBushBlock.AGE) == 4;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader newState;
        LevelWriter level;
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            level = (LevelWriter)levelReader;
            newState = (BlockState)context.getState().m_61124_((Property)BaseBushBlock.AGE, (Comparable)Integer.valueOf(2));
            level.m_7731_(context.getPosition(), (BlockState)newState, 2);
            if (this.bush instanceof DoubleFruitBushBlock) {
                LevelReader oppositeState = newState;
                BlockPos oppositePos = context.getPosition();
                if (newState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER) {
                    oppositeState = (BlockState)newState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                    oppositePos = oppositePos.m_7494_();
                } else {
                    oppositeState = (BlockState)newState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                    oppositePos = oppositePos.m_7495_();
                }
                level.m_7731_(oppositePos, (BlockState)oppositeState, 2);
            }
        }
        if ((newState = context.getLevel()) instanceof ServerLevel) {
            level = (ServerLevel)newState;
            int j = 1 + level.f_46441_.m_188503_(2);
            return Collections.singletonList(new ItemStack((ItemLike)this.fruit, j));
        }
        return Collections.emptyList();
    }
}

