/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.fruitsdelight;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class DurianBlockFruit
extends CustomizedFruit {
    private final Block block;
    private final ResourceLocation id;
    private final List<ItemStack> blockIcons;
    private final List<ItemStack> itemIcons;

    public DurianBlockFruit(FDTrees tree) {
        this(tree.getLeaves(), tree.getSapling(), tree.getFruit());
    }

    public DurianBlockFruit(BaseLeavesBlock leaves, SaplingBlock sapling, Item fruit) {
        this.block = ((BlockItem)fruit).m_40614_();
        this.id = ForgeRegistries.BLOCKS.getKey((Object)leaves);
        this.blockIcons = Arrays.asList(new ItemStack((ItemLike)leaves), new ItemStack((ItemLike)sapling));
        this.itemIcons = Arrays.asList(new ItemStack((ItemLike)fruit));
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return this.blockIcons;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60713_(this.block);
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public EquipmentTypeEntry getHarvestToolType() {
        return (EquipmentTypeEntry)ModEquipmentTypes.axe.get();
    }

    @Override
    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundEvents.f_12630_;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            level.m_7731_(context.getPosition(), Blocks.f_50016_.m_49966_(), 3);
        }
        return context.getDrops(harvester);
    }
}

