/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.crafting.IRecipeSlotModifiableGenericRecipe;
import steve_gall.minecolonies_compatibility.api.common.crafting.RecipeSlotRole;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.FarmersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingChanceResult;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class CuttingGenericRecipe
implements IRecipeSlotModifiableGenericRecipe {
    private final ResourceLocation recipeId;
    private final List<List<ItemStack>> input;
    private final List<CuttingChanceResult> allResults;
    private final List<ItemStack> primaryOutputs;
    private final List<CuttingChanceResult> additionalResults;
    private final List<ItemStack> additionalOutputs;
    private final EquipmentTypeEntry toolType;

    public CuttingGenericRecipe(CuttingBoardRecipe recipe, EquipmentTypeEntry toolType) {
        this(recipe.m_6423_(), IngredientHelper.getStacksList((List<Ingredient>)recipe.m_7527_()), recipe.getRollableResults().stream().map(CuttingChanceResult::new).toList(), toolType);
    }

    public CuttingGenericRecipe(ResourceLocation recipeId, List<List<ItemStack>> ingredients, List<CuttingChanceResult> results, EquipmentTypeEntry toolType) {
        ArrayList<CuttingChanceResult> allResults = new ArrayList<CuttingChanceResult>();
        this.recipeId = recipeId;
        this.input = ingredients;
        this.primaryOutputs = new ArrayList<ItemStack>();
        this.additionalResults = new ArrayList<CuttingChanceResult>();
        this.additionalOutputs = new ArrayList<ItemStack>();
        for (CuttingChanceResult result : results) {
            if (result.getChance() >= 1.0f && this.primaryOutputs.size() == 0) {
                this.primaryOutputs.add(result.getStack());
            } else {
                this.additionalResults.add(result);
                this.additionalOutputs.add(result.getStack());
            }
            allResults.add(result);
        }
        if (this.primaryOutputs.size() == 0) {
            ItemStack empty = new ItemStack((ItemLike)Items.f_42127_);
            empty.m_41714_((Component)Component.m_237115_((String)"minecolonies_compatibility.text.no_primary_result_item"));
            allResults.add(0, new CuttingChanceResult(empty, 0.0f));
            this.primaryOutputs.add(empty);
        }
        this.allResults = Collections.unmodifiableList(allResults);
        this.toolType = toolType;
    }

    @Override
    public boolean isRecipeSlotOptional(RecipeSlotRole role, int index) {
        if (role == RecipeSlotRole.OUTPUT && index < this.allResults.size()) {
            CuttingChanceResult result = this.allResults.get(index);
            return result.getChance() < 1.0f;
        }
        return false;
    }

    @Override
    public List<Component> getRecipeSlotToolTip(RecipeSlotRole role, int index) {
        if (role == RecipeSlotRole.OUTPUT && index < this.allResults.size()) {
            CuttingChanceResult result = this.allResults.get(index);
            return FarmersDelightModule.getChanceTooltip(result.getChance());
        }
        return Collections.emptyList();
    }

    public int getGridSize() {
        return 1;
    }

    @Nullable
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.primaryOutputs.size() == 0 ? ItemStack.f_41583_ : this.primaryOutputs.get(0);
    }

    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return this.primaryOutputs;
    }

    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @NotNull
    public List<CuttingChanceResult> getAdditionalResults() {
        return this.additionalResults;
    }

    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    @NotNull
    public Block getIntermediate() {
        return (Block)ModBlocks.CUTTING_BOARD.get();
    }

    @Nullable
    public ResourceLocation getLootTable() {
        return null;
    }

    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return this.toolType;
    }

    @Nullable
    public EntityType<?> getRequiredEntity() {
        return null;
    }

    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return Collections::emptyList;
    }

    public int getLevelSort() {
        return -1;
    }
}

