/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.delightful;

import java.util.Collections;
import java.util.List;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.SalmonberryBushBlock;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;

public class SalmonberryCrop
extends CustomizedCrop {
    @Override
    public boolean isSeed(@NotNull PlantSeedContext context) {
        return context.getSeed().m_150930_((Item)DelightfulItems.SALMONBERRY_PIPS.get());
    }

    @Override
    public boolean isCrop(@NotNull PlantBlockContext context) {
        return context.getState().m_60713_((Block)DelightfulBlocks.SALMONBERRY_BUSH.get());
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return this::getHarvestPosition;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return this::harvest;
    }

    @Nullable
    private BlockPos getHarvestPosition(@NotNull PlantBlockContext context) {
        SalmonberryBushBlock block;
        BlockState state = context.getState();
        Block block2 = state.m_60734_();
        if (block2 instanceof SalmonberryBushBlock && (block = (SalmonberryBushBlock)block2).isMaxAge(state)) {
            return context.getPosition();
        }
        return null;
    }

    @NotNull
    private List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            boolean flag = ((SalmonberryBushBlock)state.m_60734_()).isMaxAge(state);
            int count = flag ? 2 + level.f_46441_.m_188503_(2) : 1;
            level.m_7731_(context.getPosition(), (BlockState)state.m_61124_((Property)SalmonberryBushBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)DelightfulItems.SALMONBERRIES.get(), count));
        }
        return Collections.emptyList();
    }
}

