/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.network.message.JEIRecipeTransferMessage;

public abstract class TeachRecipeTransferHandler<MENU extends TeachRecipeMenu<RECIPE>, RECIPE, CATEGORY_RECIPE>
implements IRecipeTransferHandler<MENU, CATEGORY_RECIPE> {
    private final IRecipeTransferHandlerHelper recipeTransferHandlerHelper;

    public TeachRecipeTransferHandler(IRecipeTransferHandlerHelper recipeTransferHandlerHelper) {
        this.recipeTransferHandlerHelper = recipeTransferHandlerHelper;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(MENU menu, CATEGORY_RECIPE categoryRecipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        RECIPE recipe = this.getRecipe(menu, categoryRecipe, recipeSlots, player);
        if (recipe == null) {
            return this.recipeTransferHandlerHelper.createInternalError();
        }
        Component error = this.getError(menu, recipe, recipeSlots, player);
        if (error != null) {
            return this.recipeTransferHandlerHelper.createUserErrorWithTooltip(error);
        }
        if (doTransfer) {
            CompoundTag tag = new CompoundTag();
            this.serializePayload(menu, recipe, recipeSlots, player, tag);
            MineColoniesCompatibility.network().sendToServer(new JEIRecipeTransferMessage<RECIPE>(menu, recipe, tag));
        }
        return null;
    }

    protected Component getError(MENU menu, RECIPE recipe, IRecipeSlotsView recipeSlots, Player player) {
        return ((TeachRecipeMenu)menu).getRecipeError(recipe);
    }

    protected List<ItemStack> getDisplayedItemStacks(IRecipeSlotsView recipeSlots, RecipeIngredientRole role) {
        return recipeSlots.getSlotViews(role).stream().map(view -> view.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_)).toList();
    }

    protected abstract RECIPE getRecipe(MENU var1, CATEGORY_RECIPE var2, IRecipeSlotsView var3, Player var4);

    protected abstract void serializePayload(MENU var1, RECIPE var2, IRecipeSlotsView var3, Player var4, CompoundTag var5);
}

