/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.api.common.event.AnimalHerdingToolEvent;
import steve_gall.minecolonies_compatibility.core.common.crafting.AnimalHerdingLootGenericRecipe;

@Mixin(value={AnimalHerdingModule.class}, remap=false)
public abstract class AnimalHerdingModuleMixin
extends AbstractBuildingModule {
    @Shadow(remap=false)
    @NotNull
    abstract List<ItemStorage> getBreedingItems();

    @Inject(method={"getRecipesForDisplayPurposesOnly"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private void getRecipesForDisplayPurposesOnly(@NotNull Animal animal, CallbackInfoReturnable<List<IGenericRecipe>> cir) {
        HashSet toolTypes = new HashSet();
        AnimalHerdingToolEvent event = new AnimalHerdingToolEvent(animal, toolTypes::add);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (toolTypes.size() > 0) {
            List<List<ItemStorage>> breedingItems = Collections.singletonList(this.getBreedingItems());
            ArrayList<AnimalHerdingLootGenericRecipe> newList = new ArrayList<AnimalHerdingLootGenericRecipe>((Collection)cir.getReturnValue());
            for (EquipmentTypeEntry toolType : toolTypes) {
                newList.add(new AnimalHerdingLootGenericRecipe(animal.m_6095_(), breedingItems, animal.m_5743_(), toolType));
            }
            cir.setReturnValue(newList);
        }
    }
}

