/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostMenu;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class JEIGhostAcceptItemMessage
extends AbstractMessage {
    private final int slotNumber;
    private final ItemStack stack;
    private final boolean isVirtual;

    public JEIGhostAcceptItemMessage(int slotNumber, ItemStack stack, boolean isVirtual) {
        this.slotNumber = slotNumber;
        this.stack = stack;
        this.isVirtual = isVirtual;
    }

    public JEIGhostAcceptItemMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.slotNumber = buffer.readInt();
        this.stack = buffer.m_130267_();
        this.isVirtual = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.slotNumber);
        buffer.m_130055_(this.stack);
        buffer.writeBoolean(this.isVirtual);
    }

    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof IItemGhostMenu) {
            IItemGhostMenu ghostMenu = (IItemGhostMenu)abstractContainerMenu;
            ghostMenu.onGhostAcceptItem(this.slotNumber, this.stack, this.isVirtual);
        }
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

