/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.job;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.util.AttributeModifierUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.EntityAIWorkOrchardist;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.Fruit;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.OrchardistConfig;

public class JobOrchardist
extends AbstractJob<EntityAIWorkOrchardist, JobOrchardist> {
    public static final String TAG_FRUIT = "Fruit";
    @Nullable
    private Fruit fruit;

    public JobOrchardist(ICitizenData entity) {
        super(entity);
    }

    public void onLevelUp() {
        this.getCitizen().getEntity().ifPresent(this::onLevelUp);
    }

    private void onLevelUp(AbstractEntityCitizen worker) {
        ICitizenData citizen = this.getCitizen();
        OrchardistConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.orchardist;
        WorkerBuildingModule module = (WorkerBuildingModule)this.getWorkModule();
        double amount = (double)citizen.getCitizenSkillHandler().getLevel(module.getSecondarySkill()) * (Double)config.moveSpeedBonusPerSkillLevel.get();
        AttributeModifier speedModifier = new AttributeModifier("SkillSpeedBonus", amount, AttributeModifier.Operation.ADDITION);
        AttributeModifierUtils.addModifier((LivingEntity)worker, (AttributeModifier)speedModifier, (Attribute)Attributes.f_22279_);
    }

    public void onRemoval() {
        this.getCitizen().getEntity().ifPresent(this::onRemoval);
        super.onRemoval();
    }

    private void onRemoval(AbstractEntityCitizen worker) {
        AttributeModifierUtils.removeModifier((LivingEntity)worker, (String)"SkillSpeedBonus", (Attribute)Attributes.f_22279_);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.fruit != null) {
            CompoundTag fruitTag = new CompoundTag();
            this.fruit.serialize(fruitTag);
            compound.m_128365_(TAG_FRUIT, (Tag)fruitTag);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_(TAG_FRUIT)) {
            this.fruit = Fruit.deserialize(compound.m_128469_(TAG_FRUIT));
        }
    }

    public EntityAIWorkOrchardist generateAI() {
        return new EntityAIWorkOrchardist(this);
    }

    public ResourceLocation getModel() {
        return ModModelTypes.LUMBERJACK_ID;
    }

    @Nullable
    public Fruit getFruit() {
        return this.fruit;
    }

    public void setFruit(@Nullable Fruit fruit) {
        this.fruit = fruit;
    }
}

