/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostMenu;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.IRecipeTransferableMenu;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.ModuleMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuNewRecipesMessage;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuNewResultMessage;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public abstract class TeachRecipeMenu<RECIPE>
extends ModuleMenu
implements IItemGhostMenu,
IRecipeTransferableMenu<RECIPE> {
    public static final Component TEXT_RECIPE_NOT_FOUND = Component.m_237115_((String)"minecolonies_compatibility.text.recipe_not_found");
    public static final Component TEXT_RECIPE_NOT_SUPPORTED = Component.m_237115_((String)"minecolonies_compatibility.text.recipe_not_supported");
    protected TeachContainer inputContainer;
    protected List<Slot> inputSlots;
    protected Container resultContainer;
    protected List<Slot> resultSlots;
    private IMenuRecipeValidator<RECIPE> recipeValidator;
    private List<RECIPE> recipes;
    private int recipeIndex = -1;
    protected RECIPE recipe;

    public TeachRecipeMenu(MenuType<?> menuType, int windowId, Inventory inventory, IBuildingModule module) {
        super(menuType, windowId, inventory, module);
        this.setup();
    }

    public TeachRecipeMenu(MenuType<?> menuType, int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.inputSlots = new ArrayList<Slot>();
        this.resultSlots = new ArrayList<Slot>();
        this.inputContainer = null;
        this.resultContainer = null;
        this.recipeValidator = null;
        this.recipes = Collections.emptyList();
        this.recipeIndex = -1;
        this.recipe = null;
    }

    protected abstract IMenuRecipeValidator<RECIPE> createRecipeValidator();

    protected abstract void onRecipeChanged(RegistryAccess var1);

    @Override
    public IMenuRecipeValidator<RECIPE> getRecipeValidator() {
        if (this.recipeValidator == null) {
            this.recipeValidator = this.createRecipeValidator();
        }
        return this.recipeValidator;
    }

    @Override
    public final void onRecipeTransfer(@NotNull RECIPE recipe, @NotNull CompoundTag payload) {
        this.setContainerByTransfer(recipe, payload);
        this.refreshRecipes(recipe);
    }

    protected void setContainerByTransfer(@NotNull RECIPE recipe, @NotNull CompoundTag payload) {
        this.inputContainer.m_6211_();
    }

    @Override
    public void onGhostAcceptItem(int slotNumber, ItemStack stack, boolean isVirtual) {
        if (!isVirtual) {
            Slot slot = (Slot)this.f_38839_.get(slotNumber);
            this.handleSlotClick(slot, stack);
        }
    }

    public void m_6199_(Container container) {
        this.onSlotsChanged(container);
        super.m_6199_(container);
    }

    protected void onSlotsChanged(Container container) {
        if (container == this.inputContainer) {
            this.refreshRecipes(null);
        }
    }

    protected void refreshRecipes(RECIPE show) {
        Player player = this.inventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            IMenuRecipeValidator recipeValidator = this.getRecipeValidator();
            this.recipes = new ArrayList<RECIPE>(recipeValidator.findAll(this.inputContainer, player2));
            List<CompoundTag> tags = this.recipes.stream().map(r -> recipeValidator.serialize((IFactoryController)StandardFactoryController.getInstance(), r)).toList();
            MineColoniesCompatibility.network().sendToPlayer((AbstractMessage)new TeachRecipeMenuNewRecipesMessage(tags), player2);
            if (ModuleManager.POLYMORPH.isLoaded()) {
                PolymorphModule.sendRecipesList(player2, this);
            }
            this.setRecipeIndex(show == null ? 0 : this.recipes.indexOf(show));
        }
    }

    public final void onNewRecipesTransfer(List<RECIPE> recipes) {
        this.recipes = new ArrayList<RECIPE>(recipes);
        this.setRecipeIndex(-1);
    }

    protected void setRecipe(RECIPE recipe) {
        this.recipe = recipe;
        this.onRecipeChanged(this.inventory.f_35978_.m_9236_().m_9598_());
        Player player = this.inventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag tag = recipe != null ? this.getRecipeValidator().serialize((IFactoryController)StandardFactoryController.getInstance(), recipe) : null;
            MineColoniesCompatibility.network().sendToPlayer((AbstractMessage)new TeachRecipeMenuNewResultMessage(tag), player2);
            if (ModuleManager.POLYMORPH.isLoaded() && recipe instanceof Recipe) {
                PolymorphModule.sendHighlightRecipe(player2, ((Recipe)recipe).m_6423_());
            }
        }
    }

    public final void onNewResultTransfer(CompoundTag tag) {
        if (tag != null) {
            RECIPE recipe = this.getRecipeValidator().deserialize((IFactoryController)StandardFactoryController.getInstance(), tag);
            this.setRecipe(recipe);
        } else {
            this.setRecipe(null);
        }
    }

    @Nullable
    public Component getCurrentError() {
        return this.recipe != null ? this.getRecipeError(this.recipe) : TEXT_RECIPE_NOT_FOUND;
    }

    @Nullable
    public Component getRecipeError(@NotNull RECIPE recipe) {
        return null;
    }

    public void m_150399_(int slotNumber, int clickedButton, ClickType mode, Player player) {
        if (0 <= slotNumber && slotNumber < this.f_38839_.size()) {
            Slot slot = (Slot)this.f_38839_.get(slotNumber);
            if (slot.f_40218_ == this.inputContainer || slot.f_40218_ == this.resultContainer) {
                if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                    this.handleSlotClick(slot, this.m_142621_());
                }
                return;
            }
            if (mode == ClickType.QUICK_MOVE) {
                return;
            }
        }
        super.m_150399_(slotNumber, clickedButton, mode, player);
    }

    public void handleSlotClick(Slot slot, ItemStack stack) {
        if (slot.f_40218_ == this.inputContainer) {
            this.setSlot(slot, stack);
        }
    }

    protected void setSlot(Slot slot, ItemStack stack) {
        if (stack.m_41613_() > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            slot.m_5852_(copy);
        } else if (slot.m_7993_().m_41613_() > 0) {
            slot.m_5852_(ItemStack.f_41583_);
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return !this.resultSlots.contains(slot) && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public TeachContainer getInputContainer() {
        return this.inputContainer;
    }

    public List<Slot> getCraftSlots() {
        return Collections.unmodifiableList(this.inputSlots);
    }

    public Container getResultContainer() {
        return this.resultContainer;
    }

    public List<Slot> getResultSlots() {
        return Collections.unmodifiableList(this.resultSlots);
    }

    public RECIPE getRecipe() {
        return this.recipe;
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public void setRecipeIndex(int index) {
        if (0 <= index && index < this.getRecipes().size()) {
            this.recipeIndex = index;
            this.setRecipe(this.recipes.get(index));
        } else {
            this.recipeIndex = -1;
            this.setRecipe(null);
        }
    }

    public List<RECIPE> getRecipes() {
        return this.recipes;
    }
}

