/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import steve_gall.minecolonies_compatibility.core.common.building.BuildingHelper;

public class AttackRangeConfig {
    public final ForgeConfigSpec.DoubleValue base;
    public final ForgeConfigSpec.DoubleValue increasePerSkillLevel;
    public final ForgeConfigSpec.DoubleValue increasePerBuildingLevel;
    public final ForgeConfigSpec.DoubleValue maximum;
    public final ForgeConfigSpec.DoubleValue bonusOnGuard;
    public final ForgeConfigSpec.BooleanValue yDifferenceCorrection;

    public AttackRangeConfig(ForgeConfigSpec.Builder builder, DefaultValues defaultValues) {
        this.base = builder.defineInRange("base", defaultValues.base(), 2.0, 24.0);
        this.increasePerSkillLevel = builder.defineInRange("increasePerSkillLevel", defaultValues.increasePerSkillLevel(), 0.0, 24.0);
        this.increasePerBuildingLevel = builder.defineInRange("increasePerBuildingLevel", defaultValues.increasePerBuildingLevel(), 0.0, 24.0);
        this.maximum = builder.defineInRange("maximum", defaultValues.maximum(), 2.0, 48.0);
        this.bonusOnGuard = builder.defineInRange("bonusOnGuard", defaultValues.bonusOnGuard(), 0.0, 24.0);
        this.yDifferenceCorrection = builder.define("yDifferenceCorrection", defaultValues.yDifferenceCorrection());
    }

    public double apply(AbstractEntityCitizen user, int skillLevel, LivingEntity target) {
        IBuilding building = user.getCitizenData().getWorkBuilding();
        double distance = (Double)this.base.get();
        distance += (Double)this.increasePerSkillLevel.get() * (double)skillLevel;
        distance += (Double)this.increasePerBuildingLevel.get() * (double)(building != null ? building.getBuildingLevel() - 1 : 0);
        distance = Math.min(distance, (Double)this.maximum.get());
        if (((Boolean)this.yDifferenceCorrection.get()).booleanValue() && target != null) {
            distance += user.m_20186_() - target.m_20186_();
        }
        if (BuildingHelper.IsGuardsTask(building, "com.minecolonies.core.guard.setting.guard")) {
            distance += ((Double)this.bonusOnGuard.get()).doubleValue();
        }
        return distance;
    }

    public static class DefaultValues {
        private double base;
        private double increasePerSkillLevel;
        private double increasePerBuildingLevel;
        private double maximum;
        private double bonusOnGuard;
        private boolean yDifferenceCorrection;

        public double base() {
            return this.base;
        }

        public DefaultValues base(double base) {
            this.base = base;
            return this;
        }

        public double increasePerSkillLevel() {
            return this.increasePerSkillLevel;
        }

        public DefaultValues increasePerSkillLevel(double increasePerSkillLevel) {
            this.increasePerSkillLevel = increasePerSkillLevel;
            return this;
        }

        public double increasePerBuildingLevel() {
            return this.increasePerBuildingLevel;
        }

        public DefaultValues increasePerBuildingLevel(double increasePerBuildingLevel) {
            this.increasePerBuildingLevel = increasePerBuildingLevel;
            return this;
        }

        public double maximum() {
            return this.maximum;
        }

        public DefaultValues maximum(double maximum) {
            this.maximum = maximum;
            return this;
        }

        public double bonusOnGuard() {
            return this.bonusOnGuard;
        }

        public DefaultValues bonusOnGuard(double bonusOnGuard) {
            this.bonusOnGuard = bonusOnGuard;
            return this;
        }

        public boolean yDifferenceCorrection() {
            return this.yDifferenceCorrection;
        }

        public DefaultValues yDifferenceCorrection(boolean yDifferenceCorrection) {
            this.yDifferenceCorrection = yDifferenceCorrection;
            return this;
        }
    }
}

