/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraftforge.common.ForgeConfigSpec;

public class AttackDamageConfig {
    public final ForgeConfigSpec.DoubleValue base;
    public final ForgeConfigSpec.DoubleValue increasePerSkillLevel;
    public final ForgeConfigSpec.DoubleValue increasePerBuildingLevel;

    public AttackDamageConfig(ForgeConfigSpec.Builder builder, DefaultValues defaultValues) {
        this.base = builder.defineInRange("base", defaultValues.base(), 0.0, 2.147483647E9);
        this.increasePerSkillLevel = builder.defineInRange("increasePerSkillLevel", defaultValues.increasePerSkillLevel(), 0.0, 2.147483647E9);
        this.increasePerBuildingLevel = builder.defineInRange("increasePerBuildingLevel", defaultValues.increasePerBuildingLevel(), 0.0, 2.147483647E9);
    }

    public double apply(AbstractEntityCitizen user, int skillLevel) {
        IBuilding building = user.getCitizenData().getWorkBuilding();
        double damage = (Double)this.base.get();
        damage += (Double)this.increasePerSkillLevel.get() * (double)skillLevel;
        return damage += (Double)this.increasePerBuildingLevel.get() * (double)(building != null ? building.getBuildingLevel() - 1 : 0);
    }

    public static class DefaultValues {
        private double base;
        private double increasePerSkillLevel;
        private double increasePerBuildingLevel;

        public double base() {
            return this.base;
        }

        public DefaultValues base(double base) {
            this.base = base;
            return this;
        }

        public double increasePerSkillLevel() {
            return this.increasePerSkillLevel;
        }

        public DefaultValues increasePerSkillLevel(double increasePerSkillLevel) {
            this.increasePerSkillLevel = increasePerSkillLevel;
            return this;
        }

        public double increasePerBuildingLevel() {
            return this.increasePerBuildingLevel;
        }

        public DefaultValues increasePerBuildingLevel(double increasePerBuildingLevel) {
            this.increasePerBuildingLevel = increasePerBuildingLevel;
            return this;
        }
    }
}

