/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingRecipeAccessor;
import steve_gall.minecolonies_compatibility.core.common.init.ModTags;

public class SmithingCraftingType
extends CraftingType {
    public SmithingCraftingType(@NotNull ResourceLocation id) {
        super(id);
    }

    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level level) {
        ArrayList<IGenericRecipe> list = new ArrayList<IGenericRecipe>();
        TagKey<Item>[] tags = ModTags.Items.SMITHING_REQUIRED_LEVEL;
        RegistryAccess registryAccess = level.m_9598_();
        for (SmithingRecipe recipe : level.m_7465_().m_44013_(RecipeType.f_44113_)) {
            if (!(recipe instanceof SmithingRecipeAccessor)) continue;
            SmithingRecipeAccessor accesor = (SmithingRecipeAccessor)recipe;
            List<ItemStack> template = IngredientHelper.getStacks(accesor.getTemplate());
            List<ItemStack> baseList = IngredientHelper.getStacks(accesor.getBase());
            if (baseList.size() == 0) continue;
            List<ItemStack> base = Arrays.asList(baseList.get(0));
            HashSet<ItemStack> remainedAddition = new HashSet<ItemStack>(IngredientHelper.getStacks(accesor.getAddition()));
            for (int i = 0; i < tags.length; ++i) {
                TagKey<Item> tag = tags[i];
                List<ItemStack> levelAddition = remainedAddition.stream().filter(stack -> stack.m_204117_(tag)).toList();
                if (levelAddition.size() == 0) continue;
                remainedAddition.removeAll(levelAddition);
                list.addAll(SmithingCraftingType.of(recipe, registryAccess, template, base, levelAddition, i));
            }
            if (remainedAddition.size() <= 0) continue;
            list.addAll(SmithingCraftingType.of(recipe, registryAccess, template, base, new ArrayList<ItemStack>(remainedAddition), -1));
        }
        return list;
    }

    public static int getRequiredMinLevel(Ingredient addition) {
        List<ItemStack> stacks = IngredientHelper.getStacks(addition);
        return stacks.stream().mapToInt(SmithingCraftingType::getRequiredLevel).min().orElse(-1);
    }

    public static int getRequiredLevel(ItemStack addition) {
        TagKey<Item>[] tags = ModTags.Items.SMITHING_REQUIRED_LEVEL;
        for (int i = 0; i < tags.length; ++i) {
            if (!addition.m_204117_(tags[i])) continue;
            return i;
        }
        return -1;
    }

    public static List<IGenericRecipe> of(SmithingRecipe recipe, RegistryAccess registryAccess, List<ItemStack> template, List<ItemStack> base, List<ItemStack> addition, int requiredLevel) {
        return template.stream().map(t -> SmithingCraftingType.of(recipe, registryAccess, t, base, addition, requiredLevel)).toList();
    }

    public static IGenericRecipe of(SmithingRecipe recipe, RegistryAccess registryAccess, ItemStack template, List<ItemStack> base, List<ItemStack> addition, int requiredLevel) {
        int maxLevel = 5;
        ArrayList<MutableComponent> restrictions = new ArrayList<MutableComponent>();
        if (requiredLevel == maxLevel) {
            restrictions.add(Component.m_237110_((String)"com.minecolonies.coremod.jei.onelevelrestriction", (Object[])new Object[]{requiredLevel}));
        } else if (requiredLevel > 1) {
            restrictions.add(Component.m_237110_((String)"com.minecolonies.coremod.jei.levelrestriction", (Object[])new Object[]{requiredLevel, maxLevel}));
        }
        ArrayList<List<ItemStack>> input = new ArrayList<List<ItemStack>>();
        input.add(Arrays.asList(template));
        input.add(base);
        input.add(addition);
        List<ItemStack> allResults = SmithingCraftingType.getAllResults(recipe, registryAccess, template, base, addition);
        return GenericRecipe.builder().withRecipeId(recipe.m_6423_()).withOutputs(ItemStack.f_41583_, allResults).withAdditionalOutputs(Arrays.asList(new ItemStack[0])).withInputs(input).withGridSize(2).withIntermediate(Blocks.f_50016_).withLootTable(null).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.none.get()).withRequiredEntity(null).withRestrictions(restrictions).withLevelSort(requiredLevel).build();
    }

    private static List<ItemStack> getAllResults(SmithingRecipe recipe, RegistryAccess registryAccess, ItemStack template, List<ItemStack> bases, List<ItemStack> additions) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack base : bases) {
            for (ItemStack addition : additions) {
                SimpleContainer container = new SimpleContainer(3);
                container.m_6836_(0, template);
                container.m_6836_(1, base);
                container.m_6836_(2, addition);
                list.add(recipe.m_5874_((Container)container, registryAccess));
            }
        }
        return list;
    }
}

