/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.FruitIconCache;
import steve_gall.minecolonies_compatibility.core.common.building.module.FruitListModuleView;

public class FruitListModuleWindow
extends AbstractModuleWindow<FruitListModuleView> {
    public static final String INPUT_ICON = "inputIcon";
    public static final String OUTPUT_ICON = "outputIcon";
    public static final String OUTPUT_NAME = "outputName";
    public static final Component ON = Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon");
    public static final Component OFF = Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff");
    protected final FruitListModuleView module;
    protected final ScrollingList resourceList;
    private final List<FruitIconCache> groupedItemList;
    private final Map<ItemStack, String> descriptionCache;
    private final Map<ItemStack, String> hoverNameCache;
    private String filter = "";
    private int tick = 0;
    private int tickCounter = 0;
    private List<FruitIconCache> currentDisplayedList;

    public FruitListModuleWindow(FruitListModuleView module, ResourceLocation res) {
        super((IBuildingModuleView)module, res);
        this.module = module;
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.groupedItemList = new ArrayList<FruitIconCache>(CustomizedFruit.getRegistry().values().stream().filter(module.getDisplayPredicate()::test).map(FruitIconCache::new).toList());
        this.descriptionCache = new HashMap<ItemStack, String>();
        this.hoverNameCache = new HashMap<ItemStack, String>();
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> this.setFilter(input.getText()));
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        String buttonId = button.getID();
        if (Objects.equals(buttonId, "switch")) {
            int row = this.resourceList.getListElementIndexByPane((Pane)button);
            FruitIconCache fruit = this.currentDisplayedList.get(row);
            this.toggleFruits(Arrays.asList(fruit));
        } else if (Objects.equals(buttonId, "resetDefault")) {
            this.clearFruits();
        } else if (Objects.equals(buttonId, "toggleInCurrent")) {
            this.toggleFruits(this.currentDisplayedList);
        } else if (Objects.equals(buttonId, "resetInCurrent")) {
            this.removeFruits(this.currentDisplayedList);
        }
    }

    public void addFruits(Collection<FruitIconCache> fruits) {
        this.module.addIds(fruits.stream().map(fruit -> fruit.getFruit().getId()).toList());
        this.resourceList.refreshElementPanes();
    }

    public void removeFruits(Collection<FruitIconCache> fruits) {
        this.module.removeIds(fruits.stream().map(fruit -> fruit.getFruit().getId()).toList());
        this.resourceList.refreshElementPanes();
    }

    public void toggleFruits(Collection<FruitIconCache> fruits) {
        List<ResourceLocation> toRemoves = fruits.stream().map(fruit -> fruit.getFruit().getId()).filter(id -> this.module.containsId((ResourceLocation)id)).toList();
        List<ResourceLocation> toAddes = fruits.stream().map(fruit -> fruit.getFruit().getId()).filter(id -> !this.module.containsId((ResourceLocation)id)).toList();
        this.module.removeIds(toRemoves);
        this.module.addIds(toAddes);
        this.resourceList.refreshElementPanes();
    }

    public void clearFruits() {
        this.module.clearIds();
        this.resourceList.refreshElementPanes();
    }

    public void setFilter(String newFilter) {
        if (!newFilter.equals(this.filter)) {
            this.filter = newFilter;
            this.tick = 10;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
        if (!Screen.m_96638_()) {
            ++this.tickCounter;
        }
    }

    private boolean testFilter(ItemStack stack, String lowerCaseFilter) {
        return this.descriptionCache.computeIfAbsent(stack, s -> s.m_41778_().toLowerCase(Locale.US)).contains(lowerCaseFilter) || this.hoverNameCache.computeIfAbsent(stack, s -> s.m_41786_().getString().toLowerCase(Locale.US)).contains(lowerCaseFilter);
    }

    private boolean testFilter(Collection<ItemStack> stacks, String lowerCaseFilter) {
        return stacks.stream().anyMatch(stack -> this.testFilter((ItemStack)stack, lowerCaseFilter));
    }

    private boolean testFilter(FruitIconCache fruit, String lowerCaseFilter) {
        return this.testFilter(fruit.getBlockIcons(), lowerCaseFilter) || this.testFilter(fruit.getItemIcons(), lowerCaseFilter);
    }

    protected void updateResources() {
        Predicate<FruitIconCache> filterPredicate;
        String lowerCase = this.filter.toLowerCase(Locale.US);
        Predicate<FruitIconCache> predicate = filterPredicate = this.filter.isEmpty() ? fruit -> true : fruit -> this.testFilter((FruitIconCache)fruit, lowerCase);
        if (this.currentDisplayedList != null) {
            this.currentDisplayedList.clear();
            this.updateResourceList();
        }
        this.currentDisplayedList = new ArrayList<FruitIconCache>();
        this.groupedItemList.stream().filter(filterPredicate).forEach(this.currentDisplayedList::add);
        this.currentDisplayedList.sort(this::compareResources);
        this.updateResourceList();
    }

    protected int compareResources(FruitIconCache fruit1, FruitIconCache fruit2) {
        boolean isInverted = this.module.isInverted();
        boolean contains1 = this.module.containsId(fruit1.getFruit().getId());
        boolean contains2 = this.module.containsId(fruit2.getFruit().getId());
        if (isInverted) {
            return Boolean.compare(contains1, contains2);
        }
        return Boolean.compare(contains2, contains1);
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FruitListModuleWindow.this.currentDisplayedList.size();
            }

            private ItemStack getIcon(List<ItemStack> stacks) {
                int size = stacks.size();
                if (size == 0) {
                    return ItemStack.f_41583_;
                }
                int index = FruitListModuleWindow.this.tickCounter / 30 % size;
                return stacks.get(index);
            }

            public void updateElement(int index, Pane rowPane) {
                FruitIconCache fruit = FruitListModuleWindow.this.currentDisplayedList.get(index);
                ItemStack input = this.getIcon(fruit.getBlockIcons());
                ItemStack output = this.getIcon(fruit.getItemIcons());
                ItemIcon inputIcon = (ItemIcon)rowPane.findPaneOfTypeByID(FruitListModuleWindow.INPUT_ICON, ItemIcon.class);
                inputIcon.setItem(input);
                ItemIcon outputIcon = (ItemIcon)rowPane.findPaneOfTypeByID(FruitListModuleWindow.OUTPUT_ICON, ItemIcon.class);
                outputIcon.setItem(output);
                Text outputLabel = (Text)rowPane.findPaneOfTypeByID(FruitListModuleWindow.OUTPUT_NAME, Text.class);
                outputLabel.setText(output.m_41786_());
                outputLabel.setColors(0);
                boolean contains = FruitListModuleWindow.this.module.containsId(fruit.getFruit().getId());
                boolean isInverted = FruitListModuleWindow.this.module.isInverted();
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                boolean on = isInverted && !contains || !isInverted && contains;
                switchButton.setText(on ? ON : OFF);
            }
        });
    }
}

