/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.tool;

import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomizedToolSystem {
    private static final Map<ResourceLocation, CustomizedToolSystem> REGISTRY = new HashMap<ResourceLocation, CustomizedToolSystem>();
    private static final Set<EquipmentTypeEntry> DURABILITY_BASED_LEVEL_TOOL_TYPES = new HashSet<EquipmentTypeEntry>();

    public static void register(@NotNull CustomizedToolSystem toolSystem) {
        REGISTRY.put(toolSystem.getId(), toolSystem);
    }

    public static Map<ResourceLocation, CustomizedToolSystem> getRegistry() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    @Nullable
    public static CustomizedToolSystem select(@NotNull ItemStack stack) {
        return REGISTRY.values().stream().filter(it -> it.isTool(stack)).findFirst().orElse(null);
    }

    public static void registerDurabilityBasedLevel(@NotNull EquipmentTypeEntry toolType) {
        DURABILITY_BASED_LEVEL_TOOL_TYPES.add(toolType);
    }

    public static boolean isDurabilityBasedLevel(@NotNull EquipmentTypeEntry toolType) {
        return DURABILITY_BASED_LEVEL_TOOL_TYPES.contains(toolType);
    }

    public int getLevel(@NotNull ItemStack stack) {
        int unclamped = this.getLevelUnclamped(stack);
        return Math.min(unclamped, 5);
    }

    @NotNull
    public abstract ResourceLocation getId();

    public abstract boolean isTool(@NotNull ItemStack var1);

    public abstract boolean isSword(@NotNull ItemStack var1);

    public abstract boolean isSpecialTool(@NotNull ItemStack var1, @NotNull EquipmentTypeEntry var2);

    public abstract boolean isBroken(@NotNull ItemStack var1);

    public abstract int getLevelUnclamped(@NotNull ItemStack var1);

    public abstract double getAttackDamage(@NotNull ItemStack var1);
}

