/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.crafting.GenericRecipeHelper;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;

public class SimpleGenericRecipe
implements IGenericRecipe {
    @NotNull
    private final ResourceLocation recipeId;
    @NotNull
    private final List<List<ItemStack>> input;
    @NotNull
    private final ItemStack output;
    @NotNull
    private final List<ItemStack> additionalOutputs;

    public SimpleGenericRecipe(@NotNull Recipe<?> recipe, @NotNull RegistryAccess registryAccess) {
        this(recipe.m_6423_(), IngredientHelper.getStacksList((List<Ingredient>)recipe.m_7527_()), recipe.m_8043_(registryAccess));
    }

    public SimpleGenericRecipe(@NotNull ResourceLocation recipeId, @NotNull List<List<ItemStack>> ingredients, @NotNull ItemStack output) {
        this.recipeId = recipeId;
        this.input = new ArrayList<List<ItemStack>>(ingredients);
        this.output = output;
        this.additionalOutputs = GenericRecipeHelper.getAdditionalOutputs(ingredients, this::getCraftingRemainingItem);
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.getCraftingRemainingItem();
    }

    public int getGridSize() {
        return 1;
    }

    @Nullable
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return Collections.singletonList(this.output);
    }

    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    @NotNull
    public Block getIntermediate() {
        return Blocks.f_50016_;
    }

    @Nullable
    public ResourceLocation getLootTable() {
        return null;
    }

    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @Nullable
    public EntityType<?> getRequiredEntity() {
        return null;
    }

    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return Collections::emptyList;
    }

    public int getLevelSort() {
        return -1;
    }
}

