/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleContainerGenericRecipe;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleRecipeStorage;

public abstract class SimpleContainerRecipeStorage<GENERIC_RECIPE extends SimpleContainerGenericRecipe>
extends SimpleRecipeStorage<GENERIC_RECIPE> {
    private final ItemStorage container;

    public SimpleContainerRecipeStorage(IFactoryController controller, CompoundTag tag) {
        super(controller, tag);
        this.container = (ItemStorage)controller.deserialize(tag.m_128469_("container"));
    }

    public SimpleContainerRecipeStorage(ResourceLocation recipeId, List<ItemStorage> ingredients, ItemStorage container, ItemStack output) {
        super(recipeId, ingredients, output);
        this.container = container;
    }

    @Override
    public List<ItemStorage> getInput() {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>(super.getInput());
        if (!this.container.isEmpty()) {
            input.add(this.container);
        }
        return input;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.container);
    }

    @Override
    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleContainerRecipeStorage) {
            SimpleContainerRecipeStorage other = (SimpleContainerRecipeStorage)o;
            return super.equals(other) && this.container.equals((Object)other.container);
        }
        return false;
    }

    @Override
    public void serialize(IFactoryController controller, CompoundTag tag) {
        super.serialize(controller, tag);
        tag.m_128365_("container", (Tag)controller.serialize((Object)this.container));
    }

    @Override
    protected SimpleRecipeStorage.GenericRecipeFactory<GENERIC_RECIPE> getGenericRecipeFactory() {
        return (recipeId, ingredients, output) -> (SimpleContainerGenericRecipe)this.getContainerGenericRecipeFactory().create(recipeId, ingredients, Arrays.asList(this.container.getItemStack()), output);
    }

    protected abstract ContainerGenericRecipeFactory<GENERIC_RECIPE> getContainerGenericRecipeFactory();

    public static interface ContainerGenericRecipeFactory<GENERIC_RECIPE> {
        public GENERIC_RECIPE create(ResourceLocation var1, List<List<ItemStack>> var2, List<ItemStack> var3, ItemStack var4);
    }
}

