/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.ICraftingModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.WorkingBlocksPathResult;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;

public abstract class AbstractCraftingModuleWithExternalWorkingBlocks
extends AbstractCraftingBuildingModule.Custom
implements ICraftingModuleWithExternalWorkingBlocks {
    public static final String TAG_REGISTERED_POSITIONS = MineColoniesCompatibility.rl("registered_positions").toString();
    private final Set<BlockPos> workingPositions = new HashSet<BlockPos>();
    private WorkingBlocksPathResult pathReuslt;

    public AbstractCraftingModuleWithExternalWorkingBlocks(JobEntry jobEntry) {
        super(jobEntry);
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.workingPositions.clear();
        this.workingPositions.addAll(BlockPosUtil.readPosListFromNBT((CompoundTag)compound, (String)TAG_REGISTERED_POSITIONS));
    }

    public void serializeNBT(@NotNull CompoundTag compound) {
        super.serializeNBT(compound);
        BlockPosUtil.writePosListToNBT((CompoundTag)compound, (String)TAG_REGISTERED_POSITIONS, new ArrayList<BlockPos>(this.workingPositions));
    }

    @Override
    public boolean requestFindWorkingBlocks() {
        AbstractEntityCitizen worker = this.getPathFindingCitizen();
        return this.requestFindWorkingBlocks(worker);
    }

    @Override
    public boolean requestFindWorkingBlocks(@Nullable AbstractEntityCitizen citizen) {
        if (this.pathReuslt == null) {
            this.pathReuslt = (WorkingBlocksPathResult)this.createWorkingBlocksFindPath(citizen).getResult();
            this.pathReuslt.startJob(Pathfinding.getExecutor());
            return true;
        }
        if (this.pathReuslt.isDone()) {
            for (BlockPos pos : this.pathReuslt.positions) {
                if (!this.workingPositions.add(pos)) continue;
                this.onWorkingBlockAdded(pos);
            }
            this.pathReuslt = null;
            this.markDirty();
            return false;
        }
        return true;
    }

    public void onColonyTick(@NotNull IColony colony) {
        this.requestFindWorkingBlocks();
    }

    @Nullable
    protected AbstractEntityCitizen getPathFindingCitizen() {
        ICitizenData data = ((WorkerBuildingModule)this.building.getModule(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry)).getFirstCitizen();
        return data != null ? (AbstractEntityCitizen)data.getEntity().orElse(null) : null;
    }

    @Override
    public abstract boolean isWorkingBlock(@NotNull LevelReader var1, @NotNull BlockPos var2, @NotNull BlockState var3);

    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level level) {
        this.addWorkingBlock(pos);
    }

    @Override
    public boolean addWorkingBlock(@NotNull BlockPos pos) {
        BlockState state;
        Level level = this.building.getColony().getWorld();
        if (this.isWorkingBlock((LevelReader)level, pos, state = level.m_8055_(pos)) && this.workingPositions.add(pos)) {
            this.onWorkingBlockAdded(pos);
            this.markDirty();
            return true;
        }
        return false;
    }

    protected void onWorkingBlockAdded(@NotNull BlockPos pos) {
    }

    @Override
    public boolean removeWorkingBlock(@Nullable BlockPos pos) {
        if (this.workingPositions.remove(pos)) {
            this.removeWorkingBlock(pos);
            this.markDirty();
            return true;
        }
        return false;
    }

    protected void onWorkingBlockRemoved(@Nullable BlockPos pos) {
    }

    @Override
    public boolean containsWorkingBlock(@Nullable BlockPos pos) {
        return this.workingPositions.contains(pos);
    }

    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.workingPositions);
    }
}

