/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.spells.unholy;

import elocindev.deathknights.config.Configs;
import elocindev.deathknights.config.entries.spells.unholy.DeathGripConfig;
import elocindev.necronomicon.api.NecUtilsAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.internals.SpellHelper;

public class DeathGripHandler {
    private static final DeathGripConfig CONFIG = Configs.Spells.Unholy.DEATH_GRIP;
    private static final Map<class_1309, PullInfoHolder> grippedEntities = new HashMap<class_1309, PullInfoHolder>();

    public static void register() {
        CombatEvents.SPELL_CAST.register(args -> {
            class_1657 caster = args.caster();
            if (caster == null) {
                return;
            }
            if (args.spell().id().toString().equals("death_knights:death_grip")) {
                for (class_1297 target : args.targets()) {
                    class_1309 livingTarget;
                    if (!(target instanceof class_1309) || DeathGripHandler.CONFIG.entity_blacklist.contains(NecUtilsAPI.getEntityId((class_1297)(livingTarget = (class_1309)target))) || (double)livingTarget.method_6032() >= (double)caster.method_6032() * DeathGripHandler.CONFIG.health_threshold) continue;
                    DeathGripHandler.startDeathGripPull(livingTarget, caster);
                    SpellHelper.imposeCooldown((class_1657)caster, null, null, (float)0.0f);
                }
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(DeathGripHandler::updateGrippedEntities);
    }

    private static void startDeathGripPull(class_1309 target, class_1657 caster) {
        grippedEntities.put(target, new PullInfoHolder(caster));
        caster.method_37908().method_43128(null, caster.method_23317(), caster.method_23318(), caster.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
    }

    private static void updateGrippedEntities(class_3218 world) {
        Iterator<Map.Entry<class_1309, PullInfoHolder>> iterator = grippedEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1309, PullInfoHolder> entry = iterator.next();
            class_1309 target = entry.getKey();
            PullInfoHolder pullInfo = entry.getValue();
            class_1657 caster = pullInfo.caster;
            if (target.method_31481() || caster.method_31481() || !target.method_5805()) {
                iterator.remove();
                continue;
            }
            ++pullInfo.timeElapsed;
            class_243 casterPos = caster.method_19538();
            class_243 targetPos = target.method_19538();
            class_243 direction = casterPos.method_1020(targetPos).method_1029();
            double distance = casterPos.method_1022(targetPos);
            if ((double)pullInfo.timeElapsed >= DeathGripHandler.CONFIG.max_pull_time) {
                DeathGripHandler.teleportNearPlayer(target, caster);
                iterator.remove();
                continue;
            }
            if (distance <= DeathGripHandler.CONFIG.min_distance) {
                target.method_18800(0.0, 0.0, 0.0);
                DeathGripHandler.applyEffectsToTarget(target);
                iterator.remove();
                continue;
            }
            class_243 pullVelocity = direction.method_1021(DeathGripHandler.CONFIG.pull_speed);
            target.method_18800(pullVelocity.field_1352, pullVelocity.field_1351, pullVelocity.field_1350);
            target.field_6037 = true;
        }
    }

    private static void teleportNearPlayer(class_1309 target, class_1657 caster) {
        double offsetX = (caster.method_6051().method_43058() - 0.5) * 2.0;
        double offsetZ = (caster.method_6051().method_43058() - 0.5) * 2.0;
        target.method_20620(caster.method_23317() + offsetX, caster.method_23318() + 1.0, caster.method_23321() + offsetZ);
        caster.method_37908().method_43128(null, caster.method_23317(), caster.method_23318(), caster.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
    }

    private static void applyEffectsToTarget(class_1309 target) {
        for (DeathGripConfig.EffectHolder effectHolder : DeathGripHandler.CONFIG.effects) {
            class_1291 effect = (class_1291)class_7923.field_41174.method_10223(new class_2960(effectHolder.effect_id));
            if (effect == null) continue;
            class_1293 effectInstance = new class_1293(effect, (int)effectHolder.duration, (int)effectHolder.amplifier);
            target.method_6092(effectInstance);
        }
    }

    private static class PullInfoHolder {
        public final class_1657 caster;
        public int timeElapsed;

        public PullInfoHolder(class_1657 caster) {
            this.caster = caster;
            this.timeElapsed = 0;
        }
    }
}

