/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.spells.blood;

import elocindev.deathknights.config.Configs;
import elocindev.deathknights.config.entries.spells.blood.DeathStrikeConfig;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.spell_engine.api.event.CombatEvents;

public class DeathStrikeHandler {
    private static final DeathStrikeConfig CONFIG = Configs.Spells.Blood.DEATH_STRIKE;

    public static void register() {
        CombatEvents.SPELL_CAST.register(args -> {
            class_1657 caster = args.caster();
            if (caster == null) {
                return;
            }
            if (args.spell().id().toString().equals("death_knights:death_strike")) {
                DeathStrikeHandler.applyHealingOrAbsorption(caster);
            }
        });
    }

    private static void applyHealingOrAbsorption(class_1657 caster) {
        float maxHealth = caster.method_6063();
        float healAmount = maxHealth * DeathStrikeHandler.CONFIG.max_health_healing;
        if (caster.method_6032() < maxHealth) {
            caster.method_6025(healAmount);
        } else if (DeathStrikeHandler.CONFIG.apply_absorption_if_full) {
            int absorptionAmount = Math.max(4, Math.round(healAmount));
            class_1293 currentEffect = caster.method_6112(class_1294.field_5898);
            int currentAmplifier = currentEffect != null ? currentEffect.method_5578() : -1;
            int newAmplifier = absorptionAmount / 4 - 1;
            if (currentEffect == null || currentAmplifier < newAmplifier) {
                caster.method_6092(new class_1293(class_1294.field_5898, DeathStrikeHandler.CONFIG.absorption_duration, newAmplifier, false, false, true));
            } else {
                caster.method_6092(new class_1293(class_1294.field_5898, DeathStrikeHandler.CONFIG.absorption_duration, currentAmplifier, false, false, true));
            }
        }
    }
}

