/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.registry;

import elocindev.deathknights.api.types.RunebladeSize;
import elocindev.deathknights.api.types.RunebladeType;
import elocindev.deathknights.config.Configs;
import elocindev.deathknights.config.entries.JewelryConfig;
import elocindev.deathknights.item.jewelry.DKJewelryItem;
import elocindev.deathknights.item.weapon.RunebladeItem;
import elocindev.deathknights.registry.SpellSchoolRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.item.AttributeResolver;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_power.api.SpellSchools;

public class ItemRegistry {
    public static final class_1792 BLOOD_RUNE = ItemRegistry.reg(new class_1792((class_1792.class_1793)new FabricItemSettings()), "blood_stone");
    public static final class_1792 UNHOLY_RUNE = ItemRegistry.reg(new class_1792((class_1792.class_1793)new FabricItemSettings()), "unholy_stone");
    public static final class_1792 RUNECARVED_STONE = ItemRegistry.reg(new class_1792((class_1792.class_1793)new FabricItemSettings()), "runecarved_stone");
    public static final SpellBookItem BLOOD_SPELL_BOOK = SpellBooks.create((class_2960)new class_2960("death_knights", "blood"));
    public static final SpellBookItem UNHOLY_SPELL_BOOK = SpellBooks.create((class_2960)new class_2960("death_knights", "unholy"));
    public static final SpellBookItem FROST_SPELL_BOOK = SpellBooks.create((class_2960)new class_2960("death_knights", "frost"));
    public static final ArrayList<Jewelry> JEWELRY_ITEMS = new ArrayList();
    public static final Map<String, class_1792> jewelryMap = new HashMap<String, class_1792>();
    public static Jewelry FROST_DK_RING = ItemRegistry.add(new class_2960("death_knights", "frost_dk_ring"), class_1814.field_8903, true, new JewelryConfig.Item(List.of(new JewelryConfig.AttributeModifier(SpellSchools.FROST.id, 0.08f, class_1322.class_1323.field_6330), new JewelryConfig.AttributeModifier(new class_2960("generic.attack_damage"), 0.06f, class_1322.class_1323.field_6330))));
    public static Jewelry FROST_DK_NECKLACE = ItemRegistry.add(new class_2960("death_knights", "frost_dk_necklace"), class_1814.field_8903, true, new JewelryConfig.Item(List.of(new JewelryConfig.AttributeModifier(SpellSchools.FROST.id, 0.08f, class_1322.class_1323.field_6330), new JewelryConfig.AttributeModifier(new class_2960("generic.attack_damage"), 0.06f, class_1322.class_1323.field_6330))));
    public static Jewelry UNHOLY_DK_RING = ItemRegistry.add(new class_2960("death_knights", "unholy_dk_ring"), class_1814.field_8903, true, new JewelryConfig.Item(List.of(new JewelryConfig.AttributeModifier(SpellSchoolRegistry.UNHOLY.id, 0.08f, class_1322.class_1323.field_6330), new JewelryConfig.AttributeModifier(new class_2960("generic.attack_damage"), 0.06f, class_1322.class_1323.field_6330))));
    public static Jewelry UNHOLY_DK_NECKLACE = ItemRegistry.add(new class_2960("death_knights", "unholy_dk_necklace"), class_1814.field_8903, true, new JewelryConfig.Item(List.of(new JewelryConfig.AttributeModifier(SpellSchoolRegistry.UNHOLY.id, 0.08f, class_1322.class_1323.field_6330), new JewelryConfig.AttributeModifier(new class_2960("generic.attack_damage"), 0.06f, class_1322.class_1323.field_6330))));
    public static final RunebladeItem IRON_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.ONE_HANDED, (class_1832)class_1834.field_8923, 3, -2.4f, 0.5f, true), "initiate_runeblade");
    public static final RunebladeItem DIAMOND_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.ONE_HANDED, (class_1832)class_1834.field_8930, 3, -2.4f, 1.0f, true), "diamond_runeblade");
    public static final RunebladeItem NETHERITE_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.ONE_HANDED, (class_1832)class_1834.field_22033, 3, -2.4f, 2.0f, true), "netherite_runeblade");
    public static final RunebladeItem RUBY_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.ONE_HANDED, (class_1832)class_1834.field_22033, 4, -2.4f, 2.5f, true, true), "ruby_runeblade");
    public static final RunebladeItem AETERNIUM_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.ONE_HANDED, (class_1832)class_1834.field_22033, 4, -2.4f, 2.5f, true, true), "aeternium_runeblade");
    public static final RunebladeItem GREAT_IRON_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.TWO_HANDED, (class_1832)class_1834.field_8923, 6, -3.2f, 1.0f, true), "great_iron_runeblade");
    public static final RunebladeItem GREAT_DIAMOND_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.TWO_HANDED, (class_1832)class_1834.field_8930, 7, -3.2f, 2.0f, true), "great_diamond_runeblade");
    public static final RunebladeItem GREAT_NETHERITE_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.TWO_HANDED, (class_1832)class_1834.field_22033, 7, -3.2f, 4.0f, true), "great_netherite_runeblade");
    public static final RunebladeItem GREAT_RUBY_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.TWO_HANDED, (class_1832)class_1834.field_22033, 9, -3.2f, 5.0f, true, true), "great_ruby_runeblade");
    public static final RunebladeItem GREAT_AETERNIUM_RUNEBLADE = ItemRegistry.reg(new RunebladeItem(RunebladeType.ALL, RunebladeSize.TWO_HANDED, (class_1832)class_1834.field_22033, 9, -3.2f, 5.0f, true, true), "great_aeternium_runeblade");

    public static <T extends class_1792> T reg(T instance, String id) {
        return (T)((class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("death_knights", id), instance));
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("death_knights", "blood_spell_book"), (Object)BLOOD_SPELL_BOOK.method_8389());
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("death_knights", "unholy_spell_book"), (Object)UNHOLY_SPELL_BOOK.method_8389());
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("death_knights", "frost_spell_book"), (Object)FROST_SPELL_BOOK.method_8389());
        ItemRegistry.register((JewelryConfig)Configs.Items.JEWELRY.value);
        Configs.Items.JEWELRY.save();
    }

    public static void register(JewelryConfig jewelry_configs) {
        for (Jewelry entry : JEWELRY_ITEMS) {
            JewelryConfig.Item itemConfig = jewelry_configs.items.get(entry.id.toString());
            if (itemConfig == null) {
                itemConfig = entry.config;
                jewelry_configs.items.put(entry.id.toString(), entry.config);
            }
            ArrayList<DKJewelryItem.Modifier> modifiers = new ArrayList<DKJewelryItem.Modifier>();
            for (JewelryConfig.AttributeModifier modifier : itemConfig.attributes) {
                class_1320 attribute = AttributeResolver.get((class_2960)new class_2960(modifier.id));
                if (attribute == null) {
                    System.err.println("Failed to resolve EntityAttribute with id: " + modifier.id);
                    continue;
                }
                modifiers.add(new DKJewelryItem.Modifier(attribute, "Death Knight Jewelry modifier", modifier.value, modifier.operation));
            }
            entry.item().setConfigurableModifiers(modifiers);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id(), (Object)((Object)entry.item()));
        }
    }

    public static Jewelry add(class_2960 id, JewelryConfig.Item config) {
        return ItemRegistry.add(id, class_1814.field_8906, config, null, false);
    }

    public static Jewelry add(class_2960 id, class_1814 rarity, JewelryConfig.Item config) {
        return ItemRegistry.add(id, rarity, config, null, false);
    }

    public static Jewelry add(class_2960 id, class_1814 rarity, JewelryConfig.Item config, boolean fireproof) {
        return ItemRegistry.add(id, rarity, config, null, fireproof);
    }

    public static Jewelry add(class_2960 id, class_1814 rarity, boolean addLore, JewelryConfig.Item config) {
        return ItemRegistry.add(id, rarity, config, addLore ? "item." + id.method_12836() + "." + id.method_12832() + ".lore" : null, false);
    }

    public static Jewelry add(class_2960 id, class_1814 rarity, JewelryConfig.Item config, String lore, boolean fireproof) {
        FabricItemSettings settings = new FabricItemSettings().rarity(rarity);
        if (fireproof) {
            settings = settings.fireproof();
        }
        Jewelry Jewelry2 = new Jewelry(id, new DKJewelryItem((class_1792.class_1793)settings, lore), config, fireproof);
        JEWELRY_ITEMS.add(Jewelry2);
        jewelryMap.put(id.toString(), (class_1792)Jewelry2.item());
        return Jewelry2;
    }

    public record Jewelry(class_2960 id, DKJewelryItem item, JewelryConfig.Item config, boolean fireproof) {
    }
}

