/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.pillar;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.types.PillarShapeType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class PillarBlockStateProvider
extends BlockStateProvider {
    public PillarBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (PillarBlock pillar : ModBlocks.getInstance().getPillars()) {
            this.createBlockStateFile(pillar);
        }
    }

    private void createBlockStateFile(PillarBlock pillar) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(pillar);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.pillarModelLocation(pillar, PillarShapeType.PILLAR_COLUMN), this.modLoc(this.pillarSpecModelLocation(pillar, PillarShapeType.PILLAR_COLUMN)))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).addModel()).condition(PillarBlock.COLUMN, (Comparable[])new PillarShapeType[]{PillarShapeType.PILLAR_COLUMN}).end().part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.pillarModelLocation(pillar, PillarShapeType.PILLAR_BASE), this.modLoc(this.pillarSpecModelLocation(pillar, PillarShapeType.PILLAR_BASE)))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).addModel()).condition(PillarBlock.COLUMN, (Comparable[])new PillarShapeType[]{PillarShapeType.PILLAR_BASE}).end().part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.pillarModelLocation(pillar, PillarShapeType.PILLAR_CAPITAL), this.modLoc(this.pillarSpecModelLocation(pillar, PillarShapeType.PILLAR_CAPITAL)))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).addModel()).condition(PillarBlock.COLUMN, (Comparable[])new PillarShapeType[]{PillarShapeType.PILLAR_CAPITAL}).end().part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.pillarModelLocation(pillar, PillarShapeType.FULL_PILLAR), this.modLoc(this.pillarSpecModelLocation(pillar, PillarShapeType.FULL_PILLAR)))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).addModel()).condition(PillarBlock.COLUMN, (Comparable[])new PillarShapeType[]{PillarShapeType.FULL_PILLAR}).end();
        ItemModelBuilder itemBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(pillar.getRegistryName().m_135815_(), this.modLoc(this.pillarModelLocation(pillar, PillarShapeType.FULL_PILLAR)))).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemBuilder);
    }

    private String pillarModelLocation(PillarBlock pillar, PillarShapeType suffix) {
        return "block/pillar/" + pillar.getRegistryName().m_135815_() + "_" + suffix.m_7912_();
    }

    private String pillarSpecModelLocation(PillarBlock pillar, PillarShapeType suffix) {
        return "block/pillar/" + pillar.getRegistryName().m_135815_() + "_" + suffix.getSpecificationName();
    }

    @NotNull
    public String m_6055_() {
        return "Pillar BlockStates Provider";
    }
}

