/*
 * Decompiled with CFR 0.152.
 */
package RailOptimization;

import RailOptimization.PoweredRailBlockInvoker;
import java.util.HashMap;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;

public class RailLogic {
    private static final class_2350[] EAST_WEST_DIR = new class_2350[]{class_2350.field_11039, class_2350.field_11034};
    private static final class_2350[] NORTH_SOUTH_DIR = new class_2350[]{class_2350.field_11035, class_2350.field_11043};
    private static final int UPDATE_FORCE_PLACE = 82;
    public static int RAIL_POWER_LIMIT = 8;

    public static void giveShapeUpdate(class_1937 level, class_2680 state, class_2338 pos, class_2338 fromPos, class_2350 direction) {
        class_2680 oldState = level.method_8320(pos);
        class_2248.method_9611((class_2680)oldState, (class_2680)oldState.method_26191(direction.method_10153(), state, (class_1936)level, pos, fromPos), (class_1936)level, (class_2338)pos, (int)2, (int)0);
    }

    public static void setRailPowerLimit(int powerLimit) {
        RAIL_POWER_LIMIT = powerLimit;
    }

    public static void customUpdateState(class_2442 self, class_2680 state, class_1937 level, class_2338 pos) {
        boolean shouldBePowered;
        boolean bl = shouldBePowered = level.method_49803(pos) || ((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(level, pos, state, true, 0) || ((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(level, pos, state, false, 0);
        if (shouldBePowered != (Boolean)state.method_11654((class_2769)class_2442.field_11364)) {
            class_2768 railShape = (class_2768)state.method_11654((class_2769)class_2442.field_11365);
            if (railShape.method_11897()) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
                level.method_8508(pos.method_10074(), (class_2248)self, class_2350.field_11036);
                level.method_8508(pos.method_10084(), (class_2248)self, class_2350.field_11033);
            } else if (shouldBePowered) {
                RailLogic.powerLane(self, level, pos, state, railShape);
            } else {
                RailLogic.dePowerLane(self, level, pos, state, railShape);
            }
        }
    }

    public static boolean findPoweredRailSignalFaster(class_2442 self, class_1937 world, class_2338 pos, boolean bl, int distance, class_2768 shape, HashMap<class_2338, Boolean> checkedPos) {
        boolean speedCheck;
        class_2680 blockState = world.method_8320(pos);
        boolean bl2 = speedCheck = checkedPos.containsKey(pos) && checkedPos.get(pos) != false;
        if (speedCheck) {
            return world.method_49803(pos) || RailLogic.findPoweredRailSignalFaster(self, world, pos, blockState, bl, distance + 1, checkedPos);
        }
        if (blockState.method_27852((class_2248)self)) {
            class_2768 railShape = (class_2768)blockState.method_11654((class_2769)class_2442.field_11365);
            if (shape == class_2768.field_12674 && (railShape == class_2768.field_12665 || railShape == class_2768.field_12670 || railShape == class_2768.field_12668) || shape == class_2768.field_12665 && (railShape == class_2768.field_12674 || railShape == class_2768.field_12667 || railShape == class_2768.field_12666)) {
                return false;
            }
            if (((Boolean)blockState.method_11654((class_2769)class_2442.field_11364)).booleanValue()) {
                return world.method_49803(pos) || RailLogic.findPoweredRailSignalFaster(self, world, pos, blockState, bl, distance + 1, checkedPos);
            }
            return false;
        }
        return false;
    }

    public static boolean findPoweredRailSignalFaster(class_2442 self, class_1937 level, class_2338 pos, class_2680 state, boolean bl, int distance, HashMap<class_2338, Boolean> checkedPos) {
        if (distance >= RAIL_POWER_LIMIT - 1) {
            return false;
        }
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        boolean bl2 = true;
        class_2768 railShape = (class_2768)state.method_11654((class_2769)class_2442.field_11365);
        switch (railShape.ordinal()) {
            case 0: {
                if (bl) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (bl) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (bl) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    bl2 = false;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case 3: {
                if (bl) {
                    --i;
                    ++j;
                    bl2 = false;
                } else {
                    ++i;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case 4: {
                if (bl) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    bl2 = false;
                }
                railShape = class_2768.field_12665;
                break;
            }
            case 5: {
                if (bl) {
                    ++k;
                    ++j;
                    bl2 = false;
                } else {
                    --k;
                }
                railShape = class_2768.field_12665;
            }
        }
        return RailLogic.findPoweredRailSignalFaster(self, level, new class_2338(i, j, k), bl, distance, railShape, checkedPos) || bl2 && RailLogic.findPoweredRailSignalFaster(self, level, new class_2338(i, j - 1, k), bl, distance, railShape, checkedPos);
    }

    public static void powerLane(class_2442 self, class_1937 world, class_2338 pos, class_2680 mainState, class_2768 railShape) {
        world.method_8652(pos, (class_2680)mainState.method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(true)), 82);
        HashMap<class_2338, Boolean> checkedPos = new HashMap<class_2338, Boolean>();
        checkedPos.put(pos, true);
        int[] count = new int[2];
        if (railShape == class_2768.field_12665) {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                RailLogic.setRailPositionsPower(self, world, pos, checkedPos, count, i, NORTH_SOUTH_DIR[i]);
            }
            RailLogic.updateRails(self, false, world, pos, mainState, count);
        } else if (railShape == class_2768.field_12674) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                RailLogic.setRailPositionsPower(self, world, pos, checkedPos, count, i, EAST_WEST_DIR[i]);
            }
            RailLogic.updateRails(self, true, world, pos, mainState, count);
        }
    }

    public static void dePowerLane(class_2442 self, class_1937 world, class_2338 pos, class_2680 mainState, class_2768 railShape) {
        world.method_8652(pos, (class_2680)mainState.method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(false)), 82);
        int[] count = new int[2];
        if (railShape == class_2768.field_12665) {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                RailLogic.setRailPositionsDePower(self, world, pos, count, i, NORTH_SOUTH_DIR[i]);
            }
            RailLogic.updateRails(self, false, world, pos, mainState, count);
        } else if (railShape == class_2768.field_12674) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                RailLogic.setRailPositionsDePower(self, world, pos, count, i, EAST_WEST_DIR[i]);
            }
            RailLogic.updateRails(self, true, world, pos, mainState, count);
        }
    }

    private static void setRailPositionsPower(class_2442 self, class_1937 world, class_2338 pos, HashMap<class_2338, Boolean> checkedPos, int[] count, int i, class_2350 dir) {
        for (int z = 1; z < RAIL_POWER_LIMIT; ++z) {
            class_2338 newPos = pos.method_10079(dir, z);
            class_2680 state = world.method_8320(newPos);
            if (checkedPos.containsKey(newPos)) {
                if (!checkedPos.get(newPos).booleanValue()) break;
                int n = i;
                count[n] = count[n] + 1;
                continue;
            }
            if (!state.method_27852((class_2248)self) || ((Boolean)state.method_11654((class_2769)class_2442.field_11364)).booleanValue() || !world.method_49803(newPos) && !RailLogic.findPoweredRailSignalFaster(self, world, newPos, state, true, 0, checkedPos) && !RailLogic.findPoweredRailSignalFaster(self, world, newPos, state, false, 0, checkedPos)) {
                checkedPos.put(newPos, false);
                break;
            }
            checkedPos.put(newPos, true);
            world.method_8652(newPos, (class_2680)state.method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(true)), 82);
            int n = i;
            count[n] = count[n] + 1;
        }
    }

    private static void setRailPositionsDePower(class_2442 self, class_1937 world, class_2338 pos, int[] count, int i, class_2350 dir) {
        class_2338 newPos;
        class_2680 state;
        for (int z = 1; z < RAIL_POWER_LIMIT && (state = world.method_8320(newPos = pos.method_10079(dir, z))).method_27852((class_2248)self) && ((Boolean)state.method_11654((class_2769)class_2442.field_11364)).booleanValue() && !world.method_49803(newPos) && !((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(world, newPos, state, true, 0) && !((PoweredRailBlockInvoker)self).invokeFindPoweredRailSignal(world, newPos, state, false, 0); ++z) {
            world.method_8652(newPos, (class_2680)state.method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(false)), 82);
            int n = i;
            count[n] = count[n] + 1;
        }
    }

    private static void shapeUpdateEnd(class_2442 self, class_1937 world, class_2338 pos, class_2680 mainState, int endPos, class_2350 direction, int currentPos, class_2338 blockPos) {
        if (currentPos == endPos) {
            class_2338 newPos = pos.method_10079(direction, currentPos + 1);
            RailLogic.giveShapeUpdate(world, mainState, newPos, pos, direction);
            class_2680 state = world.method_8320(blockPos);
            if (state.method_27852((class_2248)self) && ((class_2768)state.method_11654((class_2769)class_2442.field_11365)).method_11897()) {
                RailLogic.giveShapeUpdate(world, mainState, newPos.method_10084(), pos, direction);
            }
        }
    }

    private static void neighborUpdateEnd(class_2442 self, class_1937 world, class_2338 pos, int endPos, class_2350 direction, class_2248 block, int currentPos, class_2338 blockPos) {
        if (currentPos == endPos) {
            class_2338 newPos = pos.method_10079(direction, currentPos + 1);
            world.method_8492(newPos, block, pos);
            class_2680 state = world.method_8320(blockPos);
            if (state.method_27852((class_2248)self) && ((class_2768)state.method_11654((class_2769)class_2442.field_11365)).method_11897()) {
                world.method_8492(newPos.method_10084(), block, blockPos);
            }
        }
    }

    private static void updateRailsSectionEastWestShape(class_2442 self, class_1937 world, class_2338 pos, int c, class_2680 mainState, class_2350 dir, int[] count, int countAmt) {
        class_2338 pos1 = pos.method_10079(dir, c);
        if (c == 0 && count[1] == 0) {
            RailLogic.giveShapeUpdate(world, mainState, pos1.method_10093(dir.method_10153()), pos, dir.method_10153());
        }
        RailLogic.shapeUpdateEnd(self, world, pos, mainState, countAmt, dir, c, pos1);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10074(), pos, class_2350.field_11033);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10084(), pos, class_2350.field_11036);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10095(), pos, class_2350.field_11043);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10072(), pos, class_2350.field_11035);
    }

    private static void updateRailsSectionNorthSouthShape(class_2442 self, class_1937 world, class_2338 pos, int c, class_2680 mainState, class_2350 dir, int[] count, int countAmt) {
        class_2338 pos1 = pos.method_10079(dir, c);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10067(), pos, class_2350.field_11039);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10078(), pos, class_2350.field_11034);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10074(), pos, class_2350.field_11033);
        RailLogic.giveShapeUpdate(world, mainState, pos1.method_10084(), pos, class_2350.field_11036);
        RailLogic.shapeUpdateEnd(self, world, pos, mainState, countAmt, dir, c, pos1);
        if (c == 0 && count[1] == 0) {
            RailLogic.giveShapeUpdate(world, mainState, pos1.method_10093(dir.method_10153()), pos, dir.method_10153());
        }
    }

    private static void updateRails(class_2442 self, boolean eastWest, class_1937 world, class_2338 pos, class_2680 mainState, int[] count) {
        if (eastWest) {
            for (int i = 0; i < EAST_WEST_DIR.length; ++i) {
                int c;
                int countAmt = count[i];
                if (i == 1 && countAmt == 0) continue;
                class_2350 dir = EAST_WEST_DIR[i];
                class_2248 block = mainState.method_26204();
                for (c = countAmt; c >= i; --c) {
                    class_2338 p = pos.method_10079(dir, c);
                    if (c == 0 && count[1] == 0) {
                        world.method_8492(p.method_10093(dir.method_10153()), block, pos);
                    }
                    RailLogic.neighborUpdateEnd(self, world, pos, countAmt, dir, block, c, p);
                    world.method_8492(p.method_10074(), block, pos);
                    world.method_8492(p.method_10084(), block, pos);
                    world.method_8492(p.method_10095(), block, pos);
                    world.method_8492(p.method_10072(), block, pos);
                    class_2338 pos2 = pos.method_10079(dir, c).method_10074();
                    world.method_8492(pos2.method_10074(), block, pos);
                    world.method_8492(pos2.method_10095(), block, pos);
                    world.method_8492(pos2.method_10072(), block, pos);
                    if (c == countAmt) {
                        world.method_8492(pos.method_10079(dir, c + 1).method_10074(), block, pos);
                    }
                    if (c != 0 || count[1] != 0) continue;
                    world.method_8492(p.method_10093(dir.method_10153()).method_10074(), block, pos);
                }
                for (c = countAmt; c >= i; --c) {
                    RailLogic.updateRailsSectionEastWestShape(self, world, pos, c, mainState, dir, count, countAmt);
                }
            }
        } else {
            for (int i = 0; i < NORTH_SOUTH_DIR.length; ++i) {
                int c;
                int countAmt = count[i];
                if (i == 1 && countAmt == 0) continue;
                class_2350 dir = NORTH_SOUTH_DIR[i];
                class_2248 block = mainState.method_26204();
                for (c = countAmt; c >= i; --c) {
                    class_2338 p = pos.method_10079(dir, c);
                    world.method_8492(p.method_10067(), block, pos);
                    world.method_8492(p.method_10078(), block, pos);
                    world.method_8492(p.method_10074(), block, pos);
                    world.method_8492(p.method_10084(), block, pos);
                    RailLogic.neighborUpdateEnd(self, world, pos, countAmt, dir, block, c, p);
                    if (c == 0 && count[1] == 0) {
                        world.method_8492(p.method_10093(dir.method_10153()), block, pos);
                    }
                    class_2338 pos2 = pos.method_10079(dir, c).method_10074();
                    world.method_8492(pos2.method_10067(), block, pos);
                    world.method_8492(pos2.method_10078(), block, pos);
                    world.method_8492(pos2.method_10074(), block, pos);
                    if (c == countAmt) {
                        world.method_8492(pos.method_10079(dir, c + 1).method_10074(), block, pos);
                    }
                    if (c != 0 || count[1] != 0) continue;
                    world.method_8492(p.method_10093(dir.method_10153()).method_10074(), block, pos);
                }
                for (c = countAmt; c >= i; --c) {
                    RailLogic.updateRailsSectionNorthSouthShape(self, world, pos, c, mainState, dir, count, countAmt);
                }
            }
        }
    }
}

