/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.boids.goals;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoidGoal
extends class_1352 {
    public static final Logger LOGGER = LogManager.getLogger();
    public final float separationInfluence;
    public final float separationRange;
    public final float alignmentInfluence;
    public final float cohesionInfluence;
    private final class_1308 mob;
    private int timeToFindNearbyEntities = 0;
    List<? extends class_1308> nearbyMobs;
    private boolean enabled = true;

    public BoidGoal(class_1308 mob, float separationInfluence, float separationRange, float alignmentInfluence, float cohesionInfluence) {
        this.mob = mob;
        this.separationInfluence = separationInfluence;
        this.separationRange = separationRange;
        this.alignmentInfluence = alignmentInfluence;
        this.cohesionInfluence = cohesionInfluence;
    }

    public boolean method_6264() {
        return true;
    }

    public void method_6268() {
        if (!this.enabled) {
            return;
        }
        if (--this.timeToFindNearbyEntities <= 0) {
            this.timeToFindNearbyEntities = this.method_38847(40);
            this.nearbyMobs = BoidGoal.getNearbyEntitiesOfSameClass(this.mob);
        } else {
            this.nearbyMobs.removeIf(class_1309::method_29504);
        }
        if (this.nearbyMobs.isEmpty()) {
            LOGGER.warn("No nearby entities found. There should always be at least the entity itself. Will disable behavior for this entity instead of crash for compatibility reasons");
            this.enabled = false;
        }
        this.mob.method_45319(this.random());
        this.mob.method_45319(this.cohesion());
        this.mob.method_45319(this.alignment());
        this.mob.method_45319(this.separation());
    }

    public static List<? extends class_1308> getNearbyEntitiesOfSameClass(class_1308 mob) {
        Predicate<class_1308> predicate = _mob -> true;
        return mob.method_37908().method_8390(mob.getClass(), mob.method_5829().method_1009(4.0, 4.0, 4.0), predicate);
    }

    public class_243 random() {
        class_243 velocity = this.mob.method_18798();
        if ((double)class_3532.method_15379((float)((float)velocity.field_1352)) < 0.1 && (double)class_3532.method_15379((float)((float)velocity.field_1350)) < 0.1) {
            return new class_243((double)this.randomSign() * 0.2, 0.0, (double)this.randomSign() * 0.2);
        }
        return class_243.field_1353;
    }

    public int randomSign() {
        boolean isNegative = this.mob.method_6051().method_43056();
        if (isNegative) {
            return -1;
        }
        return 1;
    }

    public class_243 separation() {
        class_243 c = class_243.field_1353;
        for (class_1308 class_13082 : this.nearbyMobs) {
            if (!(class_13082.method_19538().method_1020(this.mob.method_19538()).method_1033() < (double)this.separationRange)) continue;
            c = c.method_1020(class_13082.method_19538().method_1020(this.mob.method_19538()));
        }
        return c.method_1021((double)this.separationInfluence);
    }

    public class_243 alignment() {
        class_243 c = class_243.field_1353;
        for (class_1308 class_13082 : this.nearbyMobs) {
            c = c.method_1019(class_13082.method_18798());
        }
        c = c.method_1021((double)(1.0f / (float)this.nearbyMobs.size()));
        c = c.method_1020(this.mob.method_18798());
        return c.method_1021((double)this.alignmentInfluence);
    }

    public class_243 cohesion() {
        class_243 c = class_243.field_1353;
        for (class_1308 class_13082 : this.nearbyMobs) {
            c = c.method_1019(class_13082.method_19538());
        }
        c = c.method_1021((double)(1.0f / (float)this.nearbyMobs.size()));
        c = c.method_1020(this.mob.method_19538());
        return c.method_1021((double)this.cohesionInfluence);
    }
}

