/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.boids.config;

import blue.endless.jankson.Comment;
import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.api.SyntaxError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class BoidsConfig {
    private static final Jankson jankson = new Jankson.Builder().build();
    private static final Path filePath = FabricLoader.getInstance().getConfigDir().resolve("boids.json5");
    @Comment(value="The influence of separation on the overall velocity")
    public float separationInfluence = 0.5f;
    @Comment(value="The range within which separation affects the boids")
    public float separationRange = 0.9f;
    @Comment(value="The influence of alignment on the overall velocity")
    public float alignmentInfluence = 0.4f;
    @Comment(value="The influence of cohesion on the overall velocity")
    public float cohesionInfluence = 0.05f;
    @Comment(value="The minimum speed of the boids")
    public float minSpeed = 0.3f;
    @Comment(value="The maximum speed of the boids")
    public float maxSpeed = 0.8f;
    @Comment(value="Exclude entities, e.g. 'entity.minecraft.salmon'")
    public List<String> excludeEntities = new ArrayList<String>();

    private static BoidsConfig loadFromJSON(String json) throws SyntaxError {
        return (BoidsConfig)jankson.fromJson(json, BoidsConfig.class);
    }

    public static BoidsConfig load() {
        if (!Files.exists(filePath, new LinkOption[0])) {
            BoidsConfig config = new BoidsConfig();
            config.save();
            return config;
        }
        try {
            String json = Files.readString(filePath, StandardCharsets.UTF_8);
            return BoidsConfig.loadFromJSON(json);
        }
        catch (SyntaxError | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        try {
            filePath.getParent().toFile().mkdirs();
            Files.writeString(filePath, (CharSequence)this.toJSON(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJSON() {
        return jankson.toJson((Object)this).toJson(JsonGrammar.JANKSON);
    }
}

