/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.scoreboardoverhaul;

import kotlin.Metadata;
import me.jfenn.scoreboardoverhaul.CommonKt;
import me.jfenn.scoreboardoverhaul.api.IConfigFactory;
import me.jfenn.scoreboardoverhaul.api.IHudCallback;
import me.jfenn.scoreboardoverhaul.api.IOptionsAccessor;
import me.jfenn.scoreboardoverhaul.api.IScoreboardAccessor;
import me.jfenn.scoreboardoverhaul.common.hud.HudRenderer;
import me.jfenn.scoreboardoverhaul.common.hud.HudState;
import me.jfenn.scoreboardoverhaul.impl.DrawService;
import me.jfenn.scoreboardoverhaul.impl.HudCallbackImpl;
import me.jfenn.scoreboardoverhaul.impl.OptionsAccessor;
import me.jfenn.scoreboardoverhaul.impl.ScoreboardAccessor;
import me.jfenn.scoreboardoverhaul.impl.ScoreboardConfigDummyFactory;
import me.jfenn.scoreboardoverhaul.impl.ScoreboardConfigFactory;
import net.fabricmc.api.ClientModInitializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001c\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/jfenn/scoreboardoverhaul/Main;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "Lme/jfenn/scoreboardoverhaul/api/IConfigFactory;", "configFactory", "Lme/jfenn/scoreboardoverhaul/api/IConfigFactory;", "getConfigFactory", "()Lme/jfenn/scoreboardoverhaul/api/IConfigFactory;", "scoreboardoverhaul"})
public final class Main
implements ClientModInitializer {
    @NotNull
    public static final Main INSTANCE;
    private static final Logger log;
    @NotNull
    private static final IConfigFactory configFactory;

    private Main() {
    }

    @NotNull
    public final IConfigFactory getConfigFactory() {
        return configFactory;
    }

    public void onInitializeClient() {
        log.info("Starting Scoreboard Overhaul client");
        ScoreboardAccessor scoreboardAccessor = new ScoreboardAccessor();
        HudState hudState = new HudState(configFactory, (IScoreboardAccessor)scoreboardAccessor, (IOptionsAccessor)OptionsAccessor.INSTANCE);
        HudRenderer hudRenderer = new HudRenderer(configFactory, hudState, (IOptionsAccessor)OptionsAccessor.INSTANCE, (IHudCallback)new HudCallbackImpl(DrawService.Companion));
        hudState.init();
        hudRenderer.init();
    }

    static {
        IConfigFactory iConfigFactory;
        INSTANCE = new Main();
        log = LoggerFactory.getLogger(INSTANCE.getClass());
        if (CommonKt.hasClothConfig()) {
            iConfigFactory = ScoreboardConfigFactory.INSTANCE;
        } else {
            log.error("cloth-config is not installed! Scoreboard Overhaul cannot create its config menu without it!");
            iConfigFactory = (IConfigFactory)ScoreboardConfigDummyFactory.INSTANCE;
        }
        configFactory = iConfigFactory;
    }
}

