/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.custom_tracks.casing.CasingRenderUtils;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackVisual;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.ShaderLightVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrackVisual.class}, remap=false)
public abstract class MixinTrackVisual
extends AbstractVisual
implements BlockEntityVisual<TrackBlockEntity>,
ShaderLightVisual {
    @Shadow
    @Final
    protected TrackBlockEntity blockEntity;
    @Shadow
    @Final
    protected BlockPos visualPos;
    @Shadow
    @Final
    protected BlockPos pos;
    private final List<Pair<TransformedInstance, BlockPos>> casingData = new ArrayList<Pair<TransformedInstance, BlockPos>>();

    public MixinTrackVisual(VisualizationContext ctx, Level level, float partialTick) {
        super(ctx, level, partialTick);
    }

    @Shadow
    public abstract void _delete();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onCtor(VisualizationContext context, TrackBlockEntity track, float partialTick, CallbackInfo ci) {
        this.railways$makeCasingData(true);
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=0)})
    private void updateWithoutConnections(CallbackInfo ci) {
        this._delete();
        this.railways$makeCasingData(false);
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=1)})
    private void updateWithConnections(CallbackInfo ci) {
        this.railways$makeCasingData(true);
    }

    @Inject(method={"_delete"}, at={@At(value="HEAD")})
    private void railways$_delete(CallbackInfo ci) {
        this.casingData.forEach(data -> ((TransformedInstance)data.getFirst()).delete());
        this.casingData.clear();
    }

    @Unique
    private void railways$makeCasingData(boolean connections) {
        BlockState state;
        TrackShape shape;
        PoseStack ms = new PoseStack();
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).translate((Vec3i)this.visualPos)).nudge((int)this.pos.m_121878_());
        SlabBlock casingBlock = ((IHasTrackCasing)this.blockEntity).getTrackCasing();
        if (casingBlock != null && CRBlockPartials.TRACK_CASINGS.containsKey(shape = (TrackShape)(state = this.blockEntity.m_58900_()).m_61143_((Property)TrackBlock.SHAPE))) {
            ms.m_85836_();
            if (this.blockEntity.isTilted()) {
                double angle = (Double)this.blockEntity.tilt.smoothingAngle.get();
                switch ((TrackShape)state.m_61143_((Property)TrackBlock.SHAPE)) {
                    case ZO: {
                        TransformStack.of((PoseStack)ms).rotateXDegrees((float)(-angle));
                        break;
                    }
                    case XO: {
                        TransformStack.of((PoseStack)ms).rotateZDegrees((float)angle);
                    }
                }
            }
            TrackMaterial.TrackType trackType = null;
            Block block = state.m_60734_();
            if (block instanceof TrackBlock) {
                TrackBlock trackBlock = (TrackBlock)block;
                trackType = trackBlock.getMaterial().trackType;
            }
            CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
            spec = ((IHasTrackCasing)this.blockEntity).isAlternate() ? spec.getNonNullAltSpec(trackType) : spec.getFor(trackType);
            PartialModel rawCasingModel = spec.model;
            CRBlockPartials.ModelTransform transform = spec.transform;
            TransformedInstance casingInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, this.instancerProvider());
            casingInstance.setTransform(ms).rotateX(transform.rx()).rotateY(transform.ry()).rotateZ(transform.rz()).translate(transform.x(), transform.y(), transform.z());
            this.casingData.add((Pair<TransformedInstance, BlockPos>)Pair.of((Object)casingInstance, (Object)this.pos));
            for (CRBlockPartials.ModelTransform additionalTransform : spec.additionalTransforms) {
                TransformedInstance additionalInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, this.instancerProvider());
                additionalInstance.setTransform(ms).rotateX(additionalTransform.rx()).rotateY(additionalTransform.ry()).rotateZ(additionalTransform.rz()).translate(additionalTransform.x(), additionalTransform.y(), additionalTransform.z());
                this.casingData.add((Pair<TransformedInstance, BlockPos>)Pair.of((Object)additionalInstance, (Object)this.pos.m_7918_(Mth.m_14107_((double)additionalTransform.x()), Mth.m_14107_((double)additionalTransform.y()), Mth.m_14107_((double)additionalTransform.z()))));
            }
            ms.m_85849_();
        }
        if (connections) {
            for (BezierConnection bc : this.blockEntity.getConnections().values()) {
                BlockPos relativePos;
                TransformedInstance casingInstance;
                double shiftDown;
                if (!bc.isPrimary() || (casingBlock = ((IHasTrackCasing)bc).getTrackCasing()) == null) continue;
                int heightDiff = Math.abs(((BlockPos)bc.bePositions.get(false)).m_123342_() - ((BlockPos)bc.bePositions.get(true)).m_123342_());
                double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
                if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
                    for (Vec3 pos : CasingRenderUtils.casingPositions(bc)) {
                        casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                        ((TransformedInstance)((TransformedInstance)casingInstance.setTransform(ms).translate(0.0, shiftDown, 0.0)).translate(pos.f_82479_, pos.f_82480_, pos.f_82481_)).scale(1.001f);
                        relativePos = BlockPos.m_274561_((double)((double)this.pos.m_123341_() + pos.f_82479_), (double)((double)this.pos.m_123342_() + pos.f_82480_), (double)((double)this.pos.m_123343_() + pos.f_82481_));
                        this.casingData.add((Pair<TransformedInstance, BlockPos>)Pair.of((Object)casingInstance, (Object)relativePos));
                    }
                    continue;
                }
                BezierConnection.SegmentAngles segments = bc.getBakedSegments();
                for (int i = 1; i < segments.length; ++i) {
                    if (i % 2 == 0) continue;
                    casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                    ((TransformedInstance)casingInstance.setTransform(ms).mul(segments.tieTransform[i]).translate(0.0f, (float)(i % 4) * 0.001f, 0.0f).translate(0.0, shiftDown, 0.0)).scale(1.001f);
                    relativePos = segments.lightPosition[i].m_121955_((Vec3i)this.pos);
                    this.casingData.add((Pair<TransformedInstance, BlockPos>)Pair.of((Object)casingInstance, (Object)relativePos));
                    TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
                    if (trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                        for (boolean first : Iterate.trueAndFalse) {
                            for (boolean inner : Iterate.trueAndFalse) {
                                PoseStack.Pose transform = (PoseStack.Pose)segments.railTransforms[i].get(first);
                                TransformedInstance casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                                casingInstance2.setTransform(ms).mul(transform).translate(0.0f, (float)(i % 4) * 0.001f, 0.0f).translate((first ? -0.953125 : -0.03125) + (double)(inner ? 0 : (first ? 1 : -1)), shiftDown, 0.0);
                                BlockPos relativePos2 = segments.lightPosition[i].m_121955_((Vec3i)this.pos);
                                this.casingData.add((Pair<TransformedInstance, BlockPos>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                            }
                        }
                        continue;
                    }
                    for (boolean first : Iterate.trueAndFalse) {
                        PoseStack.Pose transform = (PoseStack.Pose)segments.railTransforms[i].get(first);
                        TransformedInstance casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, this.instancerProvider());
                        casingInstance2.setTransform(ms).mul(transform).translate(0.0f, (float)(i % 4) * 0.001f, 0.0f).translate(-0.5 + (trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? (first ? 0.5 : -0.5) : 0.0), shiftDown, 0.0);
                        BlockPos relativePos2 = segments.lightPosition[i].m_121955_((Vec3i)this.pos);
                        this.casingData.add((Pair<TransformedInstance, BlockPos>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                    }
                }
            }
        }
    }
}

