/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.mortuusars.horseman.horse.HitchableHorse;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements HitchableHorse {
    @Shadow
    public SimpleContainer f_30520_;
    @Unique
    protected boolean horseman$isHitched = false;
    @Unique
    protected ItemStack horseman$builtInLead = ItemStack.f_41583_;

    @Shadow
    protected abstract int m_7506_();

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public ItemStack horseman$getLead() {
        if (!HitchableHorse.isEnabled()) {
            return ItemStack.f_41583_;
        }
        if (HitchableHorse.shouldHaveLeadSlot(this)) {
            return this.f_30520_.m_8020_(HitchableHorse.getLeadSlotIndex(this));
        }
        return this.horseman$builtInLead;
    }

    @Override
    public void horseman$setLead(ItemStack stack) {
        if (HitchableHorse.shouldHaveLeadSlot(this)) {
            this.f_30520_.m_6836_(HitchableHorse.getLeadSlotIndex(this), stack);
        } else {
            this.horseman$builtInLead = stack;
        }
    }

    @Override
    public boolean horseman$isHitched() {
        return this.m_21523_() && this.horseman$isHitched;
    }

    @Override
    public void horseman$setHitched(boolean hitched) {
        this.horseman$isHitched = hitched;
    }

    @ModifyReturnValue(method={"getInventorySize"}, at={@At(value="RETURN")})
    private int onGetInventorySize(int original) {
        return HitchableHorse.shouldHaveLeadSlot(this) ? original + 1 : original;
    }

    @Inject(method={"createInventory"}, at={@At(value="HEAD")})
    private void onCreateInventory(CallbackInfo ci) {
        AbstractChestedHorse chestedHorse;
        AbstractHorse horse = (AbstractHorse)this;
        if (horse instanceof AbstractChestedHorse && (chestedHorse = (AbstractChestedHorse)horse).m_30502_() && this.m_7506_() > this.f_30520_.m_6643_() && HitchableHorse.shouldHaveLeadSlot(this)) {
            @Nullable SimpleContainer prevInventory = this.f_30520_;
            this.f_30520_ = new SimpleContainer(this.m_7506_());
            if (prevInventory != null) {
                prevInventory.m_19181_((ContainerListener)horse);
                int slots = Math.min(prevInventory.m_6643_(), this.f_30520_.m_6643_());
                for (int i = 0; i < slots; ++i) {
                    ItemStack itemStack = prevInventory.m_8020_(i);
                    if (itemStack.m_41619_()) continue;
                    this.f_30520_.m_6836_(i, itemStack.m_41777_());
                }
                if (this.f_30520_.m_8020_(2).m_150930_(Items.f_42655_)) {
                    ItemStack lastItem = this.f_30520_.m_8020_(this.f_30520_.m_6643_() - 1);
                    this.f_30520_.m_6836_(this.f_30520_.m_6643_() - 1, this.f_30520_.m_8020_(2));
                    this.f_30520_.m_6836_(2, lastItem);
                }
            }
        }
    }

    @Inject(method={"dropEquipment"}, at={@At(value="RETURN")})
    private void onDropEquipment(CallbackInfo ci) {
        if (HitchableHorse.isEnabled() && HitchableHorse.requiresLead() && !HitchableHorse.shouldHaveLeadSlot(this) && HitchableHorse.hasLead(this)) {
            this.m_19983_(HitchableHorse.getLead(this));
            HitchableHorse.setLead(this, ItemStack.f_41583_);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    protected void onAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        ItemStack leadStack = this.horseman$getLead();
        if (!leadStack.m_41619_()) {
            tag.m_128365_("HorsemanLeadItem", (Tag)leadStack.m_41739_(new CompoundTag()));
        }
        if (this.horseman$isHitched()) {
            tag.m_128379_("HorsemanHitched", true);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    protected void onReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128425_("HorsemanLeadItem", 10)) {
            ItemStack leadStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("HorsemanLeadItem"));
            if (leadStack.m_41783_() != null && leadStack.m_41783_().m_128441_("PreventLeadDrop")) {
                HitchableHorse.setHitched(this, true);
                leadStack.m_41783_().m_128473_("PreventLeadDrop");
                if (leadStack.m_41783_().m_128456_()) {
                    leadStack.m_41751_(null);
                }
            }
            this.horseman$setLead(leadStack);
        }
        this.horseman$isHitched = tag.m_128471_("HorsemanHitched");
    }
}

