/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.voidlink;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.function.Function;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class VoidLinkSlot
extends ValueBoxTransform {
    protected int index;
    private final Function<BlockState, Direction> facingGetter;
    protected final Vec3 horizontal;
    protected final Vec3 vertical;

    public VoidLinkSlot(int index, Function<BlockState, Direction> facingGetter, Vec3 position) {
        this.index = index;
        this.facingGetter = facingGetter;
        this.horizontal = index == 0 ? position.m_82520_(0.3125, 0.0, 0.0) : (index == 1 ? position : position.m_82520_(0.15625, -0.3125, 0.0));
        this.vertical = VoidLinkSlot.getVertical(this.horizontal);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFrequency() {
        return this.index < 2;
    }

    public boolean isOwner() {
        return this.index == 2;
    }

    public static Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> makeSlots(Function<Integer, VoidLinkSlot> factory) {
        return Triple.of((Object)((Object)factory.apply(0)), (Object)((Object)factory.apply(1)), (Object)((Object)factory.apply(2)));
    }

    public boolean testHit(BlockState state, Vec3 localHit) {
        Vec3 offset = this.getLocalOffset(null, null, state);
        if (offset == null) {
            return false;
        }
        return localHit.m_82554_(offset) < (double)(this.scale / 3.5f);
    }

    public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction facing = this.facingGetter.apply(state);
        if (facing.m_122434_().m_122479_()) {
            float yRot = AngleHelper.horizontalAngle((Direction)facing);
            return VecHelper.rotateCentered((Vec3)this.horizontal, (double)yRot, (Direction.Axis)Direction.Axis.Y);
        }
        return VecHelper.rotateCentered((Vec3)this.vertical, (double)(facing == Direction.DOWN ? 180.0 : 0.0), (Direction.Axis)Direction.Axis.X);
    }

    public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        float yRot;
        Direction facing = this.facingGetter.apply(state);
        float f = yRot = facing.m_122434_().m_122478_() ? 90.0f : AngleHelper.horizontalAngle((Direction)facing);
        float xRot = facing == Direction.UP ? 270.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
    }

    public float getScale() {
        return 0.4975f;
    }

    private static Vec3 getVertical(Vec3 horizontal) {
        return new Vec3(horizontal.f_82480_, horizontal.f_82481_, horizontal.f_82479_);
    }
}

