/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.tank;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.CreateUtilitiesClient;
import me.duquee.createutilities.blocks.voidtypes.VoidLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.tank.VoidTankBlock;
import me.duquee.createutilities.voidlink.VoidLinkSlot;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidTankTileEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    VoidLinkBehaviour link;

    public VoidTankTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    public void createLink() {
        Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> slots = VoidLinkSlot.makeSlots(index -> new VoidLinkSlot((int)index, state -> Direction.DOWN, VecHelper.voxelSpace((double)5.5, (double)10.5, (double)-0.001f)));
        this.link = new VoidLinkBehaviour(this, slots);
    }

    public FluidTank getFluidStorage() {
        return this.f_58857_ != null && !this.f_58857_.f_46443_ ? CreateUtilities.VOID_TANKS_DATA.computeStorageIfAbsent(this.link.getNetworkKey()) : CreateUtilitiesClient.VOID_TANKS.computeStorageIfAbsent(this.link.getNetworkKey());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(this::getFluidStorage).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.getFluidStorage().readFromNBT(tag.m_128469_("Tank"));
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        if (clientPacket) {
            tag.m_128365_("Tank", (Tag)this.getFluidStorage().writeToNBT(new CompoundTag()));
        }
        super.write(tag, clientPacket);
    }

    public boolean isClosed() {
        return (Boolean)this.m_58900_().m_61143_((Property)VoidTankBlock.CLOSED);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }
}

